<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Server;

class UpdateAllServersBandwidth extends Command
{
    protected $signature = 'servers:update-all-bandwidth';
    protected $description = 'Update bandwidth usage for all servers (Hetzner, Vultr, Arvan, etc.)';

    public function handle()
    {
        $servers = Server::all();
        $cnt = 0;
        foreach($servers as $server) {
            try {
                app(\App\Http\Controllers\ServerController::class)->updateServerBandwidth($server);
                $this->info("Updated {$server->provider} server #{$server->id}");
                $cnt++;
            } catch (\Throwable $ex) {
                $this->error("Failed for server #{$server->id}: " . $ex->getMessage());
            }
        }
        $this->info("Done. Total updated: $cnt");
        return Command::SUCCESS;
    }
}