<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $user = auth()->user();

        // مجموع موجودی کیف پول
        $walletBalance = $user->wallet_balance;

        // تعداد سرورها
        $serversCount = $user->servers()->count();

        // تعداد فاکتورهای شارژ
        $invoicesCount = $user->walletInvoices()->count();

        // آی‌پی‌های سرور
        $serverIps = $user->servers()->pluck('ip_address')->filter()->unique();

        // آخرین فاکتورهای کاربر (مثلاً ۵ تا)
        $latestInvoices = $user->walletInvoices()->latest()->take(5)->get();

        // آخرین سرورهای کاربر (مثلاً ۵ تا)
        $latestServers = $user->servers()->latest()->take(5)->get();

        // فعالیت‌های اخیر
        $activities = collect();

        // سرورهای اخیر
        foreach ($latestServers as $srv) {
            $activities->push([
                'type' => 'server',
                'desc' => "ساخت سرور <b>{$srv->name}</b>",
                'date' => $srv->created_at,
            ]);
        }

        // اکتیویتی فاکتورهای اخیر با توجه به وضعیت پرداخت
        foreach ($latestInvoices as $inv) {
            if ($inv->status == 'paid') {
                $activities->push([
                    'type' => 'invoice',
                    'desc' => "پرداخت فاکتور به مبلغ <b>" . number_format($inv->amount) . "</b> تومان",
                    'date' => $inv->created_at,
                ]);
            } elseif ($inv->status == 'pending') {
                $activities->push([
                    'type' => 'invoice-pending',
                    'desc' => "فاکتور به مبلغ <b>" . number_format($inv->amount) . "</b> تومان در انتظار پرداخت",
                    'date' => $inv->created_at,
                ]);
            } elseif ($inv->status == 'unpaid') {
                $activities->push([
                    'type' => 'invoice-unpaid',
                    'desc' => "فاکتور به مبلغ <b>" . number_format($inv->amount) . "</b> تومان پرداخت نشده",
                    'date' => $inv->created_at,
                ]);
            } elseif (in_array($inv->status, ['canceled', 'cancelled'])) {
                $activities->push([
                    'type' => 'invoice-canceled',
                    'desc' => "فاکتور به مبلغ <b>" . number_format($inv->amount) . "</b> تومان لغو شد",
                    'date' => $inv->created_at,
                ]);
            }
        }

        // نمونه لاگین‌های اخیر (اگر مدل LoginActivity داری)
        if (method_exists($user, 'loginActivities')) {
            foreach ($user->loginActivities()->latest()->take(3)->get() as $log) {
                $activities->push([
                    'type' => 'login',
                    'desc' => "ورود موفق از IP <b>{$log->ip_address}</b>",
                    'date' => $log->created_at,
                ]);
            }
        }

        // ساسپند و آن‌ساسپند سرورها
        foreach ($user->servers()->whereNotNull('suspended_at')->latest('suspended_at')->take(2)->get() as $srv) {
            $activities->push([
                'type' => 'suspend',
                'desc' => "سرور <b>{$srv->name}</b> مسدود شد.",
                'date' => $srv->suspended_at,
            ]);
        }

        // مرتب‌سازی بر اساس تاریخ
        $activities = $activities->sortByDesc('date')->take(10);

        return view('dashboards.index', compact(
            'walletBalance', 'serversCount', 'invoicesCount', 'serverIps', 'activities', 'latestInvoices', 'latestServers'
        ));
    }
}