<?php

namespace App\Http\Controllers;

use App\Services\LimitService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LimitsController extends Controller
{
    protected $limitService;

    public function __construct(LimitService $limitService)
    {
        $this->limitService = $limitService;
    }

    public function index()
    {
        $user = Auth::user();
        
        // دریافت محدودیت‌ها و استفاده از Service
        $limits = $this->limitService->getLimits();
        $usage = $this->limitService->getUsage($user->id);
        
        return view('cloud.limits', compact('limits', 'usage'));
    }
}