<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvoiceCreatedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $invoice;
    public $panel_url;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $invoice, $panel_url = null)
    {
        $this->user = $user;
        $this->invoice = $invoice;
        $this->panel_url = $panel_url;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('صدور فاکتور جدید')
            ->view('emails.invoice_created')
            ->with([
                'user' => $this->user,
                'invoice' => $this->invoice,
                'panel_url' => $this->panel_url,
            ]);
    }
}