<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvoicePaidMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $invoice;
    public $panel_url;

    public function __construct($user, $invoice, $panel_url = null)
    {
        $this->user = $user;
        $this->invoice = $invoice;
        $this->panel_url = $panel_url;
    }

    public function build()
    {
        return $this->subject('پرداخت موفق فاکتور')
            ->view('emails.invoice_paid');
    }
}