<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Models\Server;
use App\Models\Project;

class ServerCreatedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $server;
    public $project;
    public $panel_url;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $server, $panel_url = null)
    {
        // ✅ اگه User به صورت ID پاس داده شده، بارگذاری کن
        if (is_numeric($user)) {
            $this->user = User::find($user);
        } elseif (is_object($user)) {
            $this->user = $user;
        } else {
            $this->user = null;
        }

        // ✅ اگه Server به صورت ID پاس داده شده، بارگذاری کن
        if (is_numeric($server)) {
            $this->server = Server::with('project')->find($server);
        } elseif (is_object($server)) {
            $this->server = $server;
        } else {
            $this->server = null;
        }

        // ✅ بارگذاری Project از Server
        if ($this->server && $this->server->project_id) {
            $this->project = $this->server->project ?? Project::find($this->server->project_id);
        } else {
            $this->project = null;
        }

        $this->panel_url = $panel_url ?? config('app.url', 'https://console.onhost.in');
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('✅ سرور جدید شما ساخته شد - ' . ($this->server->name ?? 'سرور'))
            ->view('emails.server-created')
            ->with([
                'user' => $this->user,
                'server' => $this->server,
                'project' => $this->project,
                'panel_url' => $this->panel_url,
            ]);
    }
}