<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ServerDeletedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $server;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $server)
    {
        $this->user = $user;
        $this->server = $server;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('حذف سرور')
            ->view('emails.server_deleted')
            ->with([
                'user' => $this->user,
                'server' => $this->server,
            ]);
    }
}