<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ServerSuspendedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $server;
    public $reason;

    /**
     * Create a new message instance.
     *
     * @param $user
     * @param $server
     * @param string|null $reason
     */
    public function __construct($user, $server, $reason = null)
    {
        $this->user = $user;
        $this->server = $server;
        $this->reason = $reason;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('مسدود شدن سرور')
            ->view('emails.server_suspended')
            ->with([
                'user' => $this->user,
                'server' => $this->server,
                'reason' => $this->reason,
            ]);
    }
}