<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TestMail extends Mailable
{
    use Queueable, SerializesModels;

    public $name;

    public function __construct($name = null)
    {
        $this->name = $name;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'ایمیل تستی',
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.test', // مسیر ویوی blade ایمیل
            with: ['name' => $this->name], // پارامترها برای ویو
        );
    }

    public function attachments(): array
    {
        return [];
    }
}