<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GiftCode extends Model
{
    protected $fillable = [
        'code',
        'amount',
        'max_uses',
        'used_count',
        'is_active',
        'expires_at',
        'description',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function usages()
    {
        return $this->hasMany(GiftCodeUsage::class);
    }

    public function isValid()
    {
        if (!$this->is_active) {
            return false;
        }

        if ($this->used_count >= $this->max_uses) {
            return false;
        }

        if ($this->expires_at && $this->expires_at->isPast()) {
            return false;
        }

        return true;
    }

    public function canBeUsedBy($userId)
    {
        return !$this->usages()->where('user_id', $userId)->exists();
    }
}