<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GiftCodeUsage extends Model
{
    protected $fillable = [
        'user_id',
        'gift_code_id',
        'amount',
        'used_at',
    ];

    protected $casts = [
        'used_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function giftCode()
    {
        return $this->belongsTo(GiftCode::class);
    }
}