<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    // افزودن user_id به fillable برای محافظت از mass-assignment
    protected $fillable = ['name', 'user_id'];

    /**
     * رابطه با کاربر (مالک پروژه)
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * رابطه با سرورها
     */
    public function servers()
    {
        return $this->hasMany(Server::class, 'project_id');
    }
}