<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Server;
use Illuminate\Auth\Access\HandlesAuthorization;

class ServerPolicy
{
    use HandlesAuthorization;

    /**
     * بررسی دسترسی مشاهده سرور
     */
    public function view(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی به لیست سرورها
     */
    public function viewAny(User $user)
    {
        return true; // همه کاربران می‌توانند سرورهای خود را ببینند
    }

    /**
     * بررسی دسترسی ایجاد سرور جدید
     */
    public function create(User $user)
    {
        // می‌تونید محدودیت تعداد سرور یا اعتبار کیف پول رو چک کنید
        return true;
    }

    /**
     * بررسی دسترسی آپدیت سرور
     */
    public function update(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی حذف سرور
     */
    public function delete(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی ریبوت سرور
     */
    public function reboot(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی خاموش/روشن کردن سرور
     */
    public function power(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی نصب مجدد سرور
     */
    public function reinstall(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی به کنسول سرور
     */
    public function console(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی مدیریت شبکه (افزودن/حذف IP)
     */
    public function manageNetwork(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی مشاهده اطلاعات پهنای باند
     */
    public function viewBandwidth(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی دسترسی مشاهده لاگ‌ها و اکتیویتی
     */
    public function viewActivity(User $user, Server $server)
    {
        return $user->id === $server->user_id || ($user->is_admin ?? false);
    }

    /**
     * بررسی کلی - اگر کاربر ادمین باشه به همه چی دسترسی داره
     */
    public function before(User $user, $ability)
    {
        if ($user->is_admin ?? false) {
            return true; // ادمین به همه چیز دسترسی داره
        }
    }
}