<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\User;
use App\Observers\UserObserver;
use App\Services\WalletService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // ثبت WalletService به عنوان Singleton
        // این باعث می‌شه در کل برنامه فقط یک instance از WalletService ساخته بشه
        $this->app->singleton(WalletService::class, function ($app) {
            return new WalletService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // نمایش موجودی کیف پول کاربر در همه ویوها
        view()->composer('*', function ($view) {
            $wallet_balance = 0;
            if (auth()->check()) {
                // بهینه‌سازی: از auth()->user() استفاده کنیم بجای query جدید
                $user = auth()->user();
                $wallet_balance = $user ? $user->wallet_balance : 0;
            }
            $view->with('wallet_balance', $wallet_balance);
        });

        // ثبت Observer مدل User
        User::observe(UserObserver::class);
    }
}