<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class ParspackService
{
    protected $apiUrl = 'https://my.abrha.net/cserver/api/public/v1';
    protected $apiToken;

    public function __construct()
    {
        $this->apiToken = config('services.parspack.token'); // میاد از .env
    }

    protected function headers()
    {
        return [
            'Authorization' => 'Bearer ' . $this->apiToken,
            'Accept'        => 'application/json',
            'Content-Type'  => 'application/json',
        ];
    }

    public function listServers()
    {
        return Http::withHeaders($this->headers())
            ->get($this->apiUrl . '/vms')
            ->json();
    }

    public function createServer($planId, $name, $region = 'tehran11', $image = 'ubuntu24-cloudinit-qcow2')
    {
        return Http::withHeaders($this->headers())
            ->post($this->apiUrl . '/vms', [
                'name'   => $name,
                'region' => $region,
                'size'   => $planId,
                'image'  => $image,
            ])->json();
    }

    public function deleteServer($serverId)
    {
        return Http::withHeaders($this->headers())
            ->delete($this->apiUrl . '/vms/' . $serverId)
            ->json();
    }

    public function action($serverId, $action)
    {
        return Http::withHeaders($this->headers())
            ->post($this->apiUrl . "/vms/{$serverId}/{$action}")
            ->json();
    }
}
