<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'parspack' => [
        'token' => env('PARSPACK_API_TOKEN'),
        'base_url' => env('PARSPACK_API_URL', 'https://my.abrha.net/cserver/api/public/v1/')
    ],
    
    'whmcs' => [
        'url' => env('WHMCS_URL', 'https://client.onhost.in'),
        'username' => env('WHMCS_API_USERNAME', ''), // نام کاربری API
        'password' => env('WHMCS_API_PASSWORD', ''), // پسورد API
        'secret' => env('WHMCS_API_SECRET', 'OnHost1234'),
    ],

    'vultr' => [
        'api_key' => env('VULTR_API_KEY')
    ],

    'hetzner' => [
    'api_token' => env('HETZNER_API_TOKEN'),
    ],
    
    'arvan' => [
    'token' => env('ARVAN_API_TOKEN'),
    ],
    
    'oneprovider' => [
    'api_key' => env('ONEPROVIDER_API_KEY'),
    'client_key' => env('ONEPROVIDER_CLIENT_KEY'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

];