<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\GiftCode;

class GiftCodeSeeder extends Seeder
{
    public function run()
    {
        GiftCode::create([
            'code' => 'FIRST',
            'amount' => 50000,
            'max_uses' => 20,
            'used_count' => 0,
            'is_active' => true,
            'expires_at' => now()->addMonths(6),
            'description' => 'کد هدیه خوش‌آمدگویی برای کاربران جدید',
        ]);

        GiftCode::create([
            'code' => 'WELCOME2025',
            'amount' => 1000,
            'max_uses' => 500,
            'used_count' => 0,
            'is_active' => true,
            'expires_at' => now()->addYear(),
            'description' => 'جشنواره سال نو',
        ]);
    }
}