<?php
require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

header('Content-Type: text/plain; charset=utf-8');

echo "=== Transaction Debug ===\n\n";

$userId = 2;
$user = \App\Models\User::find($userId);

echo "User: {$user->email}\n";
echo "Balance: " . number_format($user->wallet_balance) . " تومان\n\n";

// تراکنش 70
echo "Transaction #70:\n";
$tx70 = \App\Models\WalletTransaction::find(70);
if($tx70) {
    echo "  ID: {$tx70->id}\n";
    echo "  User ID: {$tx70->user_id}\n";
    echo "  Type: {$tx70->type}\n";
    echo "  Amount: {$tx70->amount}\n";
    echo "  Status: {$tx70->status}\n";
    echo "  Created: {$tx70->created_at}\n";
    echo "  Created (Formatted): {$tx70->created_at->format('Y-m-d H:i:s')}\n";
    echo "  Month: {$tx70->created_at->format('Y-m')}\n";
} else {
    echo "  ❌ Not Found\n";
}

echo "\n";

// همه تراکنش‌های کاربر
$allTxs = \App\Models\WalletTransaction::where('user_id', $userId)
    ->orderBy('created_at', 'desc')
    ->get();
echo "Total Transactions: {$allTxs->count()}\n\n";

// تراکنش‌های نوامبر
$from = '2025-11-01 00:00:00';
$to = '2025-11-30 23:59:59';

$novTxs = \App\Models\WalletTransaction::where('user_id', $userId)
    ->whereBetween('created_at', [$from, $to])
    ->orderBy('created_at', 'desc')
    ->get();

echo "November Transactions ({$from} to {$to}): {$novTxs->count()}\n";
foreach($novTxs as $tx) {
    echo "  - #{$tx->id}: {$tx->type}, " . number_format($tx->amount) . ", {$tx->created_at->format('Y-m-d H:i:s')}\n";
}

echo "\n";

// تست WalletService
$walletService = app(\App\Services\WalletService::class);

try {
    $stats = $walletService->getUserStats($user, '2025-11-01', '2025-11-30');
    echo "WalletService Stats:\n";
    print_r($stats);
} catch(\Exception $e) {
    echo "❌ Error: {$e->getMessage()}\n";
}

echo "\n";

// تایم‌زون
echo "Timezone Config: " . config('app.timezone') . "\n";
echo "Server Time: " . now()->format('Y-m-d H:i:s') . "\n";
echo "UTC Time: " . now('UTC')->format('Y-m-d H:i:s') . "\n";