@extends('layouts.simple.master')

@section('title', 'WHMCS Clients')

@section('main_content')
<div class="container-fluid">
    <h3>WHMCS Clients (Active)</h3>

    <table class="table table-striped" id="clients-table">
        <thead>
            <tr>
                <th>ID</th><th>Name</th><th>Email</th><th>Company</th><th>Date Created</th><th>Status</th>
            </tr>
        </thead>
        <tbody id="clients-rows">
            @foreach($paginator->items() as $client)
                <tr>
                    <td>{{ $client['id'] }}</td>
                    <td>{{ trim(($client['firstname'] ?? '') . ' ' . ($client['lastname'] ?? '')) ?: '-' }}</td>
                    <td>{{ $client['email'] ?: '-' }}</td>
                    <td>{{ $client['companyname'] ?: '-' }}</td>
                    <td>{{ $client['datecreated'] ?? '-' }}</td>
                    <td>{{ $client['status'] ?? '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div id="load-more-wrap" class="text-center my-3">
        @if($paginator->hasMorePages())
            <button id="load-more-btn" class="btn btn-primary" data-next-page="{{ $paginator->currentPage() + 1 }}">Load more</button>
        @endif
    </div>

    {{-- fallback pagination links --}}
    <div class="mt-3">
        {{ $paginator->links() }}
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function(){
    const btn = document.getElementById('load-more-btn');
    if (!btn) return;

    btn.addEventListener('click', function(){
        const next = btn.dataset.nextPage;
        btn.disabled = true;
        btn.innerText = 'Loading...';

        fetch("{{ route('admin.whmcs-clients') }}?page=" + next + "&per_page={{ request('per_page',25) }}", {
            headers: { 'X-Requested-With': 'XMLHttpRequest' }
        }).then(res => res.json())
        .then(data => {
            if (data.html) {
                document.getElementById('clients-rows').insertAdjacentHTML('beforeend', data.html);
            } else if (data.clients) {
                // fallback: render rows from JSON (simple)
                data.clients.forEach(c => {
                    const row = `<tr>
                        <td>${c.id}</td>
                        <td>${(c.firstname || '') + ' ' + (c.lastname || '')}</td>
                        <td>${c.email || '-'}</td>
                        <td>${c.companyname || '-'}</td>
                        <td>${c.datecreated || '-'}</td>
                        <td>${c.status || '-'}</td>
                    </tr>`;
                    document.getElementById('clients-rows').insertAdjacentHTML('beforeend', row);
                });
            }

            if (data.next_page) {
                btn.dataset.nextPage = data.next_page;
                btn.disabled = false;
                btn.innerText = 'Load more';
            } else {
                btn.remove();
            }
        }).catch(err => {
            console.error(err);
            btn.disabled = false;
            btn.innerText = 'Load more';
            alert('Error loading more clients');
        });
    });
});
</script>
@endsection
