@extends('layouts.simple.master')

@section('title', 'داشبورد')

@section('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
<style>
.sidebar-panel-main { display: none !important; }

/* ==================== Modern Dashboard Styling ==================== */
body {
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    font-family: 'Rubik', sans-serif;
}

.dashboard-container {
    min-height: 100vh;
    padding: 70px 0 30px; /* ✅ کاهش padding */
}

/* Welcome Section */
.welcome-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 16px; /* ✅ کاهش radius */
    padding: 20px 24px; /* ✅ کاهش padding */
    color: #fff;
    margin-bottom: 24px; /* ✅ کاهش margin */
    box-shadow: 0 8px 30px rgba(102, 126, 234, 0.25);
    position: relative;
    overflow: hidden;
}

.welcome-section::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 300px; /* ✅ کاهش سایز */
    height: 300px;
    background: rgba(255,255,255,0.08);
    border-radius: 50%;
}

.welcome-section::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -10%;
    width: 250px; /* ✅ کاهش سایز */
    height: 250px;
    background: rgba(255,255,255,0.06);
    border-radius: 50%;
}

.welcome-content {
    position: relative;
    z-index: 1;
}

.welcome-title {
    font-size: 22px; /* ✅ کاهش سایز */
    font-weight: 700;
    margin-bottom: 6px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.welcome-subtitle {
    font-size: 14px; /* ✅ کاهش سایز */
    opacity: 0.9;
    font-weight: 400;
}

.welcome-time {
    font-size: 12px; /* ✅ کاهش سایز */
    opacity: 0.8;
    margin-top: 6px;
    display: flex;
    align-items: center;
    gap: 5px;
}

/* Stats Cards */
.stats-card {
    background: #fff;
    border-radius: 14px; /* ✅ کاهش radius */
    padding: 18px; /* ✅ کاهش padding */
    box-shadow: 0 3px 15px rgba(0,0,0,0.06);
    transition: all 0.3s ease;
    border: 2px solid transparent;
    height: 100%;
    position: relative;
    overflow: hidden;
}

.stats-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 80px; /* ✅ کاهش سایز */
    height: 80px;
    border-radius: 50%;
    opacity: 0.1;
    transition: all 0.3s ease;
}

.stats-card.primary::before {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stats-card.info::before {
    background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
}

.stats-card.warning::before {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.stats-card.success::before {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.stats-card:hover {
    transform: translateY(-5px); /* ✅ کاهش transform */
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.stats-card:hover::before {
    transform: scale(1.5);
}

.stats-icon {
    width: 48px; /* ✅ کاهش سایز */
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px; /* ✅ کاهش سایز */
    margin-bottom: 12px;
    position: relative;
    z-index: 1;
}

.stats-icon.primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
}

.stats-icon.info {
    background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
    color: #fff;
}

.stats-icon.warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: #fff;
}

.stats-icon.success {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: #fff;
}

.stats-value {
    font-size: 26px; /* ✅ کاهش سایز */
    font-weight: 800;
    color: #2d3748;
    margin-bottom: 4px;
    position: relative;
    z-index: 1;
}

.stats-label {
    font-size: 12px; /* ✅ کاهش سایز */
    color: #718096;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    position: relative;
    z-index: 1;
}

/* Section Cards */
.section-card {
    background: #fff;
    border-radius: 14px; /* ✅ کاهش radius */
    box-shadow: 0 3px 15px rgba(0,0,0,0.06);
    overflow: hidden;
    height: 100%;
}

.section-header {
    padding: 16px 20px; /* ✅ کاهش padding */
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.section-title {
    font-size: 16px; /* ✅ کاهش سایز */
    font-weight: 700;
    color: #2d3748;
    display: flex;
    align-items: center;
    gap: 8px;
    margin: 0;
}

.section-link {
    font-size: 13px; /* ✅ کاهش سایز */
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.section-link:hover {
    color: #764ba2;
    transform: translateX(-4px);
}

.section-body {
    padding: 0;
    max-height: 350px; /* ✅ کاهش ارتفاع */
    overflow-y: auto;
}

/* Custom Scrollbar */
.section-body::-webkit-scrollbar {
    width: 5px; /* ✅ کاهش عرض */
}

.section-body::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.section-body::-webkit-scrollbar-thumb {
    background: #cbd5e0;
    border-radius: 3px;
}

.section-body::-webkit-scrollbar-thumb:hover {
    background: #a0aec0;
}

/* List Items */
.item-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.item-list li {
    padding: 12px 20px; /* ✅ کاهش padding */
    border-bottom: 1px solid #f7fafc;
    transition: all 0.3s ease;
}

.item-list li:last-child {
    border-bottom: none;
}

.item-list li:hover {
    background: linear-gradient(90deg, #f8f9fa 0%, #fff 100%);
}

/* Invoice Item */
.invoice-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.invoice-info {
    display: flex;
    flex-direction: column;
    gap: 3px; /* ✅ کاهش gap */
}

.invoice-id {
    font-weight: 700;
    color: #2d3748;
    font-size: 14px; /* ✅ کاهش سایز */
}

.invoice-date {
    font-size: 12px; /* ✅ کاهش سایز */
    color: #a0aec0;
}

.invoice-details {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 5px; /* ✅ کاهش gap */
}

.invoice-amount {
    font-weight: 700;
    color: #2d3748;
    font-size: 14px; /* ✅ کاهش سایز */
}

/* Server Item */
.server-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.server-info {
    display: flex;
    align-items: center;
    gap: 12px; /* ✅ کاهش gap */
    flex: 1;
}

.server-flag {
    width: 28px; /* ✅ کاهش سایز */
    height: 28px;
    border-radius: 6px;
    object-fit: cover;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}

.server-details {
    display: flex;
    flex-direction: column;
    gap: 3px; /* ✅ کاهش gap */
}

.server-name {
    font-weight: 700;
    color: #2d3748;
    font-size: 14px; /* ✅ کاهش سایز */
    display: flex;
    align-items: center;
    gap: 6px;
}

.server-location {
    font-size: 11px; /* ✅ کاهش سایز */
    color: #a0aec0;
    font-weight: 600;
}

.server-ip {
    font-size: 12px; /* ✅ کاهش سایز */
    color: #718096;
    font-family: 'Courier New', monospace;
}

/* Badges */
.status-badge {
    padding: 3px 10px; /* ✅ کاهش padding */
    border-radius: 16px;
    font-size: 11px; /* ✅ کاهش سایز */
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.4px;
}

.status-badge.paid {
    background: linear-gradient(135deg, #d4fc79 0%, #96e6a1 100%);
    color: #22543d;
}

.status-badge.pending {
    background: linear-gradient(135deg, #ffecd2 0%, #fcb69f 100%);
    color: #744210;
}

.status-badge.unpaid {
    background: linear-gradient(135deg, #e0e0e0 0%, #bdbdbd 100%);
    color: #424242;
}

.status-badge.canceled {
    background: linear-gradient(135deg, #757575 0%, #424242 100%);
    color: #fff;
}

.status-badge.active {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    color: #fff;
}

.status-badge.suspended {
    background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
    color: #fff;
}

/* Activity Log */
.activity-log {
    list-style: none;
    padding: 0;
    margin: 0;
}

.activity-log li {
    padding: 12px 20px; /* ✅ کاهش padding */
    border-bottom: 1px solid #f7fafc;
    display: flex;
    align-items: center;
    gap: 12px; /* ✅ کاهش gap */
    transition: all 0.3s ease;
}

.activity-log li:last-child {
    border-bottom: none;
}

.activity-log li:hover {
    background: linear-gradient(90deg, #f8f9fa 0%, #fff 100%);
}

.activity-icon {
    width: 36px; /* ✅ کاهش سایز */
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 16px; /* ✅ کاهش سایز */
    flex-shrink: 0;
}

.activity-content {
    flex: 1;
}

.activity-text {
    color: #2d3748;
    font-size: 13px; /* ✅ کاهش سایز */
    margin-bottom: 3px;
}

.activity-time {
    font-size: 11px; /* ✅ کاهش سایز */
    color: #a0aec0;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 32px 20px; /* ✅ کاهش padding */
}

.empty-icon {
    font-size: 48px; /* ✅ کاهش سایز */
    color: #e2e8f0;
    margin-bottom: 12px;
}

.empty-text {
    color: #a0aec0;
    font-size: 13px; /* ✅ کاهش سایز */
}

/* Buttons */
.btn-modern {
    padding: 6px 16px; /* ✅ کاهش padding */
    border-radius: 8px;
    font-weight: 600;
    font-size: 12px; /* ✅ کاهش سایز */
    transition: all 0.3s ease;
    border: none;
}

.btn-modern.primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
}

.btn-modern.primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

/* Responsive */
@media (max-width: 768px) {
    .welcome-title {
        font-size: 18px;
    }
    
    .stats-value {
        font-size: 20px;
    }
    
    .server-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 6px;
    }
}

/* Animations */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px); /* ✅ کاهش transform */
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-fade-in {
    animation: fadeInUp 0.5s ease-out forwards; /* ✅ کاهش duration */
}

.animate-delay-1 { animation-delay: 0.08s; }
.animate-delay-2 { animation-delay: 0.15s; }
.animate-delay-3 { animation-delay: 0.22s; }
.animate-delay-4 { animation-delay: 0.3s; }
</style>
@endsection

@section('main_content')
<div class="dashboard-container">
    <div class="container-fluid">
        <!-- Welcome Section -->
        <div class="welcome-section animate-fade-in">
            <div class="welcome-content">
                <div class="welcome-title">
                    <i class="ri-hand-heart-line"></i>
                    سلام، {{ auth()->user()->name ?? 'کاربر گرامی' }}!
                </div>
                <div class="welcome-subtitle">
                    به داشبورد OnHost خوش آمدید
                </div>
                <div class="welcome-time">
                    <i class="ri-time-line"></i>
                    {{ \Illuminate\Support\Carbon::now('Asia/Tehran')->locale('fa')->isoFormat('dddd، jD jMMMM jYYYY - HH:mm') }}
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row g-4 mb-4">
            <!-- Balance -->
            <div class="col-xl-3 col-lg-6 col-md-6 animate-fade-in animate-delay-1">
                <div class="stats-card primary">
                    <div class="stats-icon primary">
                        <i class="ri-wallet-3-line"></i>
                    </div>
                    <div class="stats-value counter">{{ $walletBalance ?? 0 }}</div>
                    <div class="stats-label">موجودی کیف پول (تومان)</div>
                </div>
            </div>

            <!-- Servers -->
            <div class="col-xl-3 col-lg-6 col-md-6 animate-fade-in animate-delay-2">
                <div class="stats-card info">
                    <div class="stats-icon info">
                        <i class="ri-server-line"></i>
                    </div>
                    <div class="stats-value counter">{{ $serversCount }}</div>
                    <div class="stats-label">تعداد سرورها</div>
                </div>
            </div>

            <!-- Invoices -->
            <div class="col-xl-3 col-lg-6 col-md-6 animate-fade-in animate-delay-3">
                <div class="stats-card warning">
                    <div class="stats-icon warning">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                    <div class="stats-value counter">{{ $invoicesCount }}</div>
                    <div class="stats-label">فاکتورها</div>
                </div>
            </div>

            <!-- IPs -->
            <div class="col-xl-3 col-lg-6 col-md-6 animate-fade-in animate-delay-4">
                <div class="stats-card success">
                    <div class="stats-icon success">
                        <i class="ri-global-line"></i>
                    </div>
                    <div class="stats-value counter">{{ $serverIps->count() }}</div>
                    <div class="stats-label">آدرس IP</div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="row g-4">
            <!-- Latest Invoices -->
            <div class="col-lg-6 animate-fade-in">
                <div class="section-card">
                    <div class="section-header">
                        <h5 class="section-title">
                            <i class="ri-file-list-3-line"></i>
                            آخرین فاکتورها
                        </h5>
                        <a href="https://console.onhost.in/wallet/charge" class="section-link">
                            مشاهده همه <i class="ri-arrow-left-s-line"></i>
                        </a>
                    </div>
                    <div class="section-body">
                        <ul class="item-list">
                            @forelse($latestInvoices as $invoice)
                            <li>
                                <div class="invoice-item">
                                    <div class="invoice-info">
                                        <div class="invoice-id">
                                            <i class="ri-file-text-line me-2"></i>
                                            فاکتور #{{ $invoice->id }}
                                        </div>
                                        <div class="invoice-date">
                                            {{ \Illuminate\Support\Carbon::parse($invoice->created_at)->locale('fa')->isoFormat('jD jMMMM jYYYY') }}
                                        </div>
                                    </div>
                                    <div class="invoice-details">
                                        <div class="invoice-amount">
                                            {{ number_format($invoice->amount) }} تومان
                                        </div>
                                        @if($invoice->status == 'paid')
                                            <span class="status-badge paid">پرداخت شده</span>
                                        @elseif($invoice->status == 'pending')
                                            <span class="status-badge pending">در انتظار</span>
                                        @elseif($invoice->status == 'unpaid')
                                            <span class="status-badge unpaid">پرداخت نشده</span>
                                        @elseif(in_array($invoice->status, ['canceled', 'cancelled']))
                                            <span class="status-badge canceled">لغو شده</span>
                                        @endif
                                    </div>
                                </div>
                            </li>
                            @empty
                            <li>
                                <div class="empty-state">
                                    <div class="empty-icon">
                                        <i class="ri-file-list-line"></i>
                                    </div>
                                    <div class="empty-text">هنوز فاکتوری ثبت نشده است</div>
                                </div>
                            </li>
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Latest Servers -->
            <div class="col-lg-6 animate-fade-in">
                <div class="section-card">
                    <div class="section-header">
                        <h5 class="section-title">
                            <i class="ri-server-line"></i>
                            سرورهای شما
                        </h5>
                        <a href="https://console.onhost.in/cloud/project-create" class="section-link">
                            مشاهده همه <i class="ri-arrow-left-s-line"></i>
                        </a>
                    </div>
                    <div class="section-body">
                        <ul class="item-list">
                            @php
                                $regionCountryMap = [
                                    'atl' => ['us', 'آتلانتا'],
                                    'hil' => ['us', 'هیلزبورو'],
                                    'fra' => ['de', 'فرانکفورت'],
                                    'hel' => ['fi', 'هلسینکی'],
                                    'lhr' => ['gb', 'لندن'],
                                    'syd' => ['au', 'سیدنی'],
                                    'ams' => ['nl', 'آمستردام'],
                                    'sgp' => ['sg', 'سنگاپور'],
                                    'cdg' => ['fr', 'پاریس'],
                                    'nbg1' => ['de', 'نورنبرگ'],
                                    'fsn1' => ['de', 'فالکنشتاین'],
                                    'hel1' => ['fi', 'هلسینکی'],
                                ];
                            @endphp
                            @forelse($latestServers as $server)
                                @php
                                    $region = strtolower($server->region ?? '');
                                    $countryCode = $regionCountryMap[$region][0] ?? '';
                                    $cityName = $regionCountryMap[$region][1] ?? $region;
                                @endphp
                            <li>
                                <div class="server-item">
                                    <div class="server-info">
                                        @if($countryCode)
                                            <img src="{{ asset('assets/flags/' . $countryCode . '.svg') }}" 
                                                 alt="flag" 
                                                 class="server-flag" 
                                                 onerror="this.style.display='none'">
                                        @endif
                                        <div class="server-details">
                                            <div class="server-name">
                                                {{ $server->name }}
                                                @if($server->status == 'active')
                                                    <span class="status-badge active">فعال</span>
                                                @elseif($server->status == 'suspended')
                                                    <span class="status-badge suspended">مسدود</span>
                                                @else
                                                    <span class="status-badge unpaid">{{ $server->status }}</span>
                                                @endif
                                            </div>
                                            <div class="server-location">
                                                <i class="ri-map-pin-line me-1"></i>
                                                {{ $cityName }} ({{ strtoupper($countryCode) }})
                                            </div>
                                            <div class="server-ip">
                                                <i class="ri-global-line me-1"></i>
                                                {{ $server->ip_address }}
                                            </div>
                                        </div>
                                    </div>
                                    @if($server->status != 'suspended')
                                        <a href="{{ route('servers.overview', ['server' => $server->id]) }}" 
                                           class="btn-modern primary">
                                            <i class="ri-settings-3-line me-1"></i>
                                            مدیریت
                                        </a>
                                    @endif
                                </div>
                            </li>
                            @empty
                            <li>
                                <div class="empty-state">
                                    <div class="empty-icon">
                                        <i class="ri-server-line"></i>
                                    </div>
                                    <div class="empty-text">هنوز سروری ایجاد نشده است</div>
                                </div>
                            </li>
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="row mt-4">
            <div class="col-12 animate-fade-in">
                <div class="section-card">
                    <div class="section-header">
                        <h5 class="section-title">
                            <i class="ri-history-line"></i>
                            فعالیت‌های اخیر
                        </h5>
                    </div>
                    <div class="section-body">
                        <ul class="activity-log">
                            @forelse($activities as $activity)
                            <li>
                                <div class="activity-icon">
                                    <i class="ri-flashlight-line"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-text">{!! $activity['desc'] !!}</div>
                                    <div class="activity-time">
                                        <i class="ri-time-line me-1"></i>
                                        {{ \Illuminate\Support\Carbon::parse($activity['date'])->locale('fa')->diffForHumans() }}
                                    </div>
                                </div>
                            </li>
                            @empty
                            <li>
                                <div class="empty-state">
                                    <div class="empty-icon">
                                        <i class="ri-history-line"></i>
                                    </div>
                                    <div class="empty-text">هیچ فعالیتی ثبت نشده است</div>
                                </div>
                            </li>
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
document.addEventListener('DOMContentLoaded', () => {
    // Counter Animation
    function easeOutCubic(t) { 
        return 1 - Math.pow(1 - t, 3); 
    }

    document.querySelectorAll('.counter').forEach(el => {
        const target = parseFloat(el.textContent.replace(/,/g, '')) || 0;
        const duration = 1500;
        const startTime = performance.now();

        function step(now) {
            const progress = Math.min((now - startTime) / duration, 1);
            const val = (target * easeOutCubic(progress)).toFixed(0);
            el.textContent = new Intl.NumberFormat('fa-IR').format(val);
            if (progress < 1) requestAnimationFrame(step);
        }
        requestAnimationFrame(step);
    });
});
</script>
@endsection