<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="utf-8">
    <title>ایجاد سرور جدید</title>
    <meta name="viewport" content="width=650">
    <!-- فونت فارسی Vazirmatn -->
    <link href="https://cdn.fontcdn.ir/Font/Persian/Vazirmatn/Vazirmatn.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
        body, p, ul, li, a, span, td {
            font-family: Tahoma, 'Vazirmatn', Arial, sans-serif !important;
            direction: rtl;
        }
        body {
            background-color: #f6f7fb;
            width: 650px;
            padding: 0 12px;
            margin: 0;
        }
        .text-center { 
            text-align: center;
        }
        ul { 
            margin: 0 0 15px 0; 
            padding: 0 20px; 
        }
        li { 
            font-size: 14px; 
            margin-bottom: 8px; 
            line-height: 1.6;
        }
        p { 
            font-size: 14px; 
            line-height: 1.8; 
            margin: 0 0 10px 0;
        }
        code {
            background: #f5f5f5;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            color: #d63384;
            font-size: 13px;
        }
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-success {
            background: #d1fae5;
            color: #065f46;
        }
        .badge-warning {
            background: #fef3c7;
            color: #92400e;
        }
        .badge-info {
            background: #dbeafe;
            color: #1e40af;
        }
    </style>
</head>
<body style="margin: 30px auto;">
    <table style="width: 100%">
        <tbody>
            <tr>
                <td>
                    <table style="background-color: #f6f7fb; width: 100%">
                        <tbody>
                            <tr>
                                <td>
                                    {{-- Header --}}
                                    <table style="margin: 0 auto; margin-bottom: 30px; width: 650px;">
                                        <tbody>
                                            <tr style="display: flex; align-items: center; justify-content: space-between;">
                                                <td>
                                                    <img src="{{ asset('assets/images/logo/logo.png') }}" alt="لوگو" style="height:48px;">
                                                </td>
                                                <td style="text-align: left; color:#999; font-size: 13px;">
                                                    <span>✅ ایجاد سرور جدید</span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    {{-- Main Content --}}
                                    <table style="margin: 0 auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.06);">
                                        <tbody>
                                            <tr>
                                                <td style="padding: 30px">
                                                    {{-- Greeting --}}
                                                    <p style="font-size: 16px; font-weight: bold; color: #111;">
                                                        سلام 
                                                        @if($user && is_object($user))
                                                            {{ $user->name ?? $user->login ?? 'کاربر عزیز' }}
                                                        @else
                                                            کاربر عزیز
                                                        @endif
                                                        ،
                                                    </p>

                                                    <p>سرور جدید شما با موفقیت ایجاد شد و آماده استفاده است! 🎉</p>

                                                    {{-- Server Info --}}
                                                    @if($server && is_object($server))
                                                    <div style="background: #f8fafc; border-right: 4px solid #7366ff; padding: 20px; border-radius: 6px; margin: 20px 0;">
                                                        <p style="font-weight: bold; margin-bottom: 15px; color: #333;">📋 مشخصات سرور:</p>
                                                        <ul style="margin: 0; padding: 0 20px;">
                                                            <li>
                                                                <strong>نام سرور:</strong> 
                                                                <code>{{ $server->name }}</code>
                                                            </li>
                                                            
                                                            <li>
                                                                <strong>Provider:</strong> 
                                                                <span class="badge badge-info">{{ strtoupper($server->provider) }}</span>
                                                            </li>
                                                            
                                                            <li>
                                                                <strong>Region:</strong> 
                                                                {{ strtoupper($server->region) }}
                                                            </li>
                                                            
                                                            <li>
                                                                <strong>Plan:</strong> 
                                                                {{ $server->plan }}
                                                            </li>
                                                            
                                                            @if($server->image)
                                                            <li>
                                                                <strong>سیستم عامل:</strong> 
                                                                {{ $server->image }}
                                                            </li>
                                                            @endif
                                                            
                                                            <li>
                                                                <strong>IP Address:</strong> 
                                                                @if($server->ip_address && $server->ip_address !== '0.0.0.0')
                                                                    <code>{{ $server->ip_address }}</code>
                                                                @else
                                                                    <span style="color: #f59e0b;">⏳ در حال اختصاص...</span>
                                                                @endif
                                                            </li>
                                                            
                                                            <li>
                                                                <strong>وضعیت:</strong> 
                                                                @if($server->status === 'active' || $server->status === 'running')
                                                                    <span class="badge badge-success">✅ فعال</span>
                                                                @elseif($server->status === 'creating' || $server->status === 'pending')
                                                                    <span class="badge badge-warning">⏳ در حال ساخت</span>
                                                                @else
                                                                    <span class="badge badge-info">{{ $server->status }}</span>
                                                                @endif
                                                            </li>

                                                            @if($project && is_object($project))
                                                            <li>
                                                                <strong>پروژه:</strong> 
                                                                {{ $project->name }}
                                                            </li>
                                                            @endif
                                                        </ul>
                                                    </div>

                                                    {{-- Login Credentials --}}
                                                    <div style="background: #fef3c7; border-right: 4px solid #f59e0b; padding: 20px; border-radius: 6px; margin: 20px 0;">
                                                        <p style="font-weight: bold; margin-bottom: 15px; color: #92400e;">🔐 اطلاعات ورود:</p>
                                                        <ul style="margin: 0; padding: 0 20px;">
                                                            <li>
                                                                <strong>نام کاربری:</strong> 
                                                                <code>root</code> 
                                                                <span style="font-size: 12px; color: #666;">(Linux)</span> 
                                                                یا 
                                                                <code>administrator</code> 
                                                                <span style="font-size: 12px; color: #666;">(Windows)</span>
                                                            </li>
                                                            
                                                            @if($server->password)
                                                            <li>
                                                                <strong>رمز عبور:</strong> 
                                                                <code style="background: #fff; padding: 4px 8px;">{{ $server->password }}</code>
                                                            </li>
                                                            @else
                                                            <li>
                                                                <strong>رمز عبور:</strong> 
                                                                <span style="color: #f59e0b;">رمز از طریق Provider ارسال می‌شود</span>
                                                            </li>
                                                            @endif
                                                        </ul>
                                                        
                                                        <p style="font-size: 12px; color: #92400e; margin-top: 15px; margin-bottom: 0;">
                                                            ⚠️ <strong>توجه:</strong> این رمز عبور فقط یک بار نمایش داده می‌شود. لطفاً آن را در مکانی امن ذخیره کنید.
                                                        </p>
                                                    </div>

                                                    {{-- Pricing Info --}}
                                                    @if($server->price_hourly_toman)
                                                    <div style="background: #f0f9ff; border-right: 4px solid #0284c7; padding: 15px; border-radius: 6px; margin: 20px 0;">
                                                        <p style="margin: 0;">
                                                            <strong>💰 هزینه ساعتی:</strong> 
                                                            <span style="font-size: 16px; color: #0284c7; font-weight: bold;">
                                                                {{ number_format($server->price_hourly_toman) }} تومان
                                                            </span>
                                                        </p>
                                                    </div>
                                                    @endif
                                                    @else
                                                    <div style="background: #fef2f2; border-right: 4px solid #ef4444; padding: 15px; border-radius: 6px;">
                                                        <p style="margin: 0; color: #991b1b;">
                                                            ⚠️ خطا در دریافت اطلاعات سرور. لطفاً به پنل مدیریت مراجعه کنید.
                                                        </p>
                                                    </div>
                                                    @endif

                                                    {{-- Action Button --}}
                                                    <div class="text-center" style="margin: 25px 0;">
                                                        <a href="{{ $panel_url ?? config('app.url', 'https://console.onhost.in') }}"
                                                           style="padding: 12px 30px; background-color: #7366ff; color: #fff; display: inline-block; border-radius: 6px; text-decoration:none; font-weight: bold; font-size: 15px; box-shadow: 0 4px 12px rgba(115,102,255,0.3);">
                                                           🔗 ورود به پنل مدیریت
                                                        </a>
                                                    </div>

                                                    {{-- Additional Info --}}
                                                    <div style="background: #f9fafb; padding: 15px; border-radius: 6px; margin-top: 20px;">
                                                        <p style="font-size: 13px; color: #666; margin: 0;">
                                                            💡 <strong>نکته:</strong> 
                                                            @if($server && ($server->status === 'creating' || $server->status === 'pending'))
                                                                سرور شما در حال آماده‌سازی است. این فرآیند ممکن است 2-5 دقیقه طول بکشد.
                                                            @else
                                                                سرور شما آماده استفاده است. می‌توانید از طریق پنل مدیریت به آن دسترسی داشته باشید.
                                                            @endif
                                                        </p>
                                                    </div>

                                                    <p style="margin-top: 20px;">در صورت نیاز به پشتیبانی یا سوال، با تیم پشتیبانی ما تماس بگیرید.</p>

                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    {{-- Footer --}}
                                    <table style="margin: 0 auto; margin-top: 30px; width: 650px;">
                                        <tbody>
                                            <tr style="text-align: center">
                                                <td>
                                                    <p style="color: #999; margin-bottom: 5px; font-size: 12px;">
                                                        این ایمیل به صورت خودکار ارسال شده است. لطفاً به آن پاسخ ندهید.
                                                    </p>
                                                    <p style="color: #999; margin-bottom: 0; font-size: 12px;">
                                                        © {{ date('Y') }} OnHost Cloud Platform - تمامی حقوق محفوظ است
                                                    </p>
                                                    <p style="color: #999; margin-top: 10px; font-size: 11px;">
                                                        عدم تمایل به دریافت ایمیل؟ 
                                                        <a href="{{ config('app.url') }}/settings/notifications" style="color: #7366ff; text-decoration: none;">
                                                            تنظیمات اعلان‌ها
                                                        </a>
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
</body>
</html>