      <div class="pt-2 mb-4 mb-lg-3 pb-lg-4 profile-wrapper">
        <div class="row g-4">
          <ul class="list-group list-group-flush border-dashed mb-5 ms-2 w-100">
            <li class="list-group-item ps-0">
              <div class="row align-items-center g-3">
                <div class="col-auto">
                  <div class="avatar-sm p-1 py-2 h-auto bg-light rounded-3 text-center">
                    <h5 class="mb-0">{{ strtoupper(substr($server->name ?? 'SV', 0, 2)) }}</h5>
                    <div class="text-muted small">{{ strtoupper(substr($server->plan ?? $server->plan_id ?? '—', 0, 2)) }}</div>
                  </div>
                </div>
                <div class="col">
                  <h5 class="mt-0 mb-1">
                    @php
                      $statusVal = strtolower($server->status ?? '');
                      $statusClass = in_array($statusVal, ['active','running','on']) ? 'text-success'
                        : (in_array($statusVal, ['creating','pending','starting','initializing','installing']) ? 'text-warning'
                        : (in_array($statusVal, ['off','stopped']) ? 'text-secondary' : 'text-muted'));
                    @endphp
                    <span id="server-status">
                      <i class="ri-circle-fill {{ $statusClass }}"></i>
                    </span>
                    <span id="server-name" class="ms-1">{{ $server->name ?? 'Unknown' }}</span>
                  </h5>
                  <div class="hstack text-muted gap-2">
                    <div class="me-2"><i class="ri-global-line"></i>
                      <span style="cursor: pointer;" id="copy-ip" onclick="copyToClipboard('{{ $server->ip_address ?? $server->main_ip ?? '-' }}')">
                        {{ $server->ip_address ?? $server->main_ip ?? '-' }}
                      </span>
                    </div>
                    <div class="me-2">
                      @php
                        $countryCode = $server->country_code ?? 'us';
                        if($server->provider === 'hetzner' && isset($apiData) && isset($apiData->datacenter)) {
                            $datacenter = $apiData->datacenter;
                            if (is_object($datacenter) && isset($datacenter->location->country)) {
                                $countryCode = strtolower($datacenter->location->country);
                            } elseif (is_array($datacenter) && isset($datacenter['location']['country'])) {
                                $countryCode = strtolower($datacenter['location']['country']);
                            }
                        }
                      @endphp
                      <img src="{{ asset('assets/flags/' . $countryCode . '.svg') }}" class="me-1 mb-1" alt="flag" width="15" onerror="this.style.display='none'">
                      <span>
                        @php
                          $city = $country = null;
                          if(($server->provider ?? '') === 'hetzner' && isset($apiData) && isset($apiData->datacenter)) {
                              $datacenter = $apiData->datacenter;
                              if (is_object($datacenter) && isset($datacenter->location)) {
                                  $loc = $datacenter->location;
                                  $city = is_object($loc) ? ($loc->city ?? null) : ($loc['city'] ?? null);
                                  $country = is_object($loc) ? ($loc->country ?? null) : ($loc['country'] ?? null);
                              } elseif (is_array($datacenter) && isset($datacenter['location'])) {
                                  $loc = $datacenter['location'];
                                  $city = is_array($loc) ? ($loc['city'] ?? null) : ($loc->city ?? null);
                                  $country = is_array($loc) ? ($loc['country'] ?? null) : ($loc->country ?? null);
                              }
                          }
                        @endphp
                        @if($city && $country)
                            {{ $city }} ({{ strtoupper($country) }})
                        @else
                            {{ $server->region ?? $server->location ?? '-' }}
                        @endif
                      </span>
                    </div>
                  </div>
                </div>
                <div class="col-sm-auto">
                  <div class="btn-group">
                    <button onclick="OpenConsole()" type="button" class="btn btn-soft-info btn-md waves-effect waves-light me-2" title="کنسول">
                      <i class="ri-terminal-line"></i>
                    </button>
                    <button type="button" class="btn btn-dark dropdown-toggle btn-md me-2" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      اکشن‌ها
                    </button>
                    <div class="dropdown-menu">
                      <button onclick="PowerServer(0)" type="button" class="dropdown-item text-danger">
                        <i class="ri-shut-down-line"></i> خاموش
                      </button>
                      <button onclick="PowerServer(1)" type="button" class="dropdown-item text-success">
                        <i class="ri-power-line"></i> روشن
                      </button>
                      <button onclick="RebootServer()" type="button" class="dropdown-item">
                        <i class="ri-restart-line"></i> ریبوت
                      </button>
                      <button onclick="OpenConsole()" type="button" class="dropdown-item">
                        <i class="ri-terminal-line"></i> کنسول
                      </button>
                      <button onclick="DeleteServer()" type="button" class="dropdown-item text-danger">
                        <i class="ri-delete-bin-6-line"></i> حذف سرور
                      </button>
                    </div>
                    <button onclick="PowerServer(0)" type="button" class="btn btn-soft-danger waves-effect btn-md">
                      <i class="ri-shut-down-line"></i> خاموش
                    </button>
                  </div>
                </div>
              </div>
            </li>
          </ul>
        </div>
      </div>

<!-- Info boxes row -->
<div class="row mb-4">
  <div class="col-lg-2 col-md-4 col-6 mb-3">
    <div class="p-3 border border-dashed info-box-custom">
      <img src="{{ asset('assets/svg/hourglass.svg') }}" alt="Active Time">
      <div>
        <div class="info-label">مدت فعال بودن</div>
        <div class="info-value">
          @php
            // فاصله زمان ایجاد تا الان بر حسب ساعت
            $activeHours = $server->created_at ? $server->created_at->diffInHours(now()) : 0;
          @endphp
      {{ floor($activeHours) }} ساعت
        </div>
      </div>
    </div>
  </div>

<div class="col-lg-2 col-md-4 col-6 mb-3">
  <div class="p-3 border border-dashed info-box-custom">
    <img src="{{ asset('assets/svg/price.svg') }}" alt="Cost">
    <div>
      <div class="info-label">هزینه این ماه</div>
      <div class="info-value">
       {{ number_format($costThisMonth ?? 0) }} تومان
      </div>
    </div>
  </div>
</div>
        <div class="col-lg-2 col-md-4 col-6 mb-3">
          <div class="p-3 border border-dashed info-box-custom">

   <img src="{{ asset('assets/svg/ip.svg') }}" alt="ip">

            <div>
              <div class="info-label">IP</div>
              <div class="info-value">
                <span id="ip-for-copy" style="cursor:pointer;" onclick="copyToClipboard('{{ $server->ip_address ?? $server->main_ip ?? '-' }}')">{{ $server->ip_address ?? $server->main_ip ?? '-' }}</span>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-2 col-md-4 col-6 mb-3">
          <div class="p-3 border border-dashed info-box-custom">
            <img src="{{ asset('assets/svg/password.svg') }}" alt="Password">
            <div>
              <div class="info-label">رمز عبور</div>
              <div class="info-value">
                @if($server->provider === 'hetzner')
                  @if(!empty($server->password))
                    <span class="password-field blur" id="password-field" style="cursor:pointer;" onclick="togglePassword()">
                      {{ str_repeat('*', strlen($server->password)) }}
                    </span>
                  @else
                    <span class="text-muted" style="font-size:13px;">رمز اولیه فقط در اولین ساخت نمایش داده می‌شود.<br>در صورت نیاز به رمز جدید، سرور را نصب مجدد کنید.</span>
                  @endif
                @else
                  @if(!empty($server->password))
                    <span class="password-field blur" id="password-field" style="cursor:pointer;" onclick="togglePassword()">
                      {{ str_repeat('*', strlen($server->password)) }}
                    </span>
                  @else
                    <span class="text-danger">رمز ثبت نشده</span>
                  @endif
                @endif
              </div>
            </div>
          </div>
        </div>
<div class="col-lg-2 col-md-4 col-6 mb-3">
  <div class="p-3 border border-dashed info-box-custom">
    <img id="os-icon" src="{{ asset('assets/os-icons/os-unknown.svg') }}" alt="OS" width="32" height="32" style="vertical-align:middle;">
    <div>
      <div class="info-label">سیستم عامل</div>
      <div class="info-value" id="info-os-name">
        {{ $osName ?? '-' }}
      </div>
    </div>
  </div>
</div>
        <div class="col-lg-2 col-md-4 col-6 mb-3">
          <div class="p-3 border border-dashed info-box-custom">
            <img src="{{ asset('assets/svg/status.svg') }}" alt="Status">
            <div>
              <div class="info-label">وضعیت سرور</div>
              <div class="info-value">
                @php
                  $status = $server->status ?? '-';
                  $statusText = [
                    'active'        => 'روشن',
                    'running'       => 'روشن',
                    'on'            => 'روشن',
                    'stopped'       => 'خاموش',
                    'off'           => 'خاموش',
                    'suspended'     => 'مسدود',
                    'creating'      => 'در حال ساخت',
                    'installing'    => 'در حال نصب',
                    'reinstalling'  => 'در حال نصب مجدد',
                    'pending'       => 'در انتظار',
                    'deleting'      => 'در حال حذف',
                  ][$status] ?? $status;

                  $statusClass = match($status) {
                    'active', 'running', 'on' => 'text-success',
                    'creating', 'installing', 'reinstalling', 'pending', 'deleting' => 'text-warning',
                    'suspended' => 'text-danger',
                    'stopped', 'off' => 'text-secondary',
                    default => 'text-muted',
                  };

                  $statusIcon = match($status) {
                    'active', 'running', 'on' => 'ri-checkbox-circle-fill',
                    'stopped', 'off' => 'ri-pause-circle-fill',
                    'suspended' => 'ri-error-warning-fill',
                    'creating', 'installing', 'reinstalling', 'pending', 'deleting' => 'ri-time-fill',
                    default => 'ri-question-fill',
                  };
                @endphp
                <span class="{{ $statusClass }}">
                  <i class="ri {{ $statusIcon }} align-middle me-1"></i>
                  {{ $statusText }}
                  @if(in_array($status, ['creating', 'installing', 'reinstalling', 'pending', 'deleting']))
                    <span class="spinner-border spinner-border-sm align-middle ms-1" role="status" aria-hidden="true"></span>
                  @endif
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /Info boxes row -->