<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="utf-8">
    <title>پرداخت فاکتور موفق بود</title>
    <meta name="viewport" content="width=650">
    <link href="https://cdn.fontcdn.ir/Font/Persian/Vazirmatn/Vazirmatn.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
        body, p, ul, li, a, span, td {
            font-family: Tahoma, 'Vazirmatn', Arial, sans-serif !important;
            direction: rtl;
        }
        body {
            background-color: #f6f7fb;
            width: 650px;
            padding: 0 12px;
        }
        .text-center { text-align: center }
        ul { margin: 0 0 15px 0; padding: 0 20px; }
        li { font-size: 14px; margin-bottom: 8px; }
        p { font-size: 14px; line-height: 1.8; margin: 0 0 10px 0;}
    </style>
</head>
<body style="margin: 30px auto;">
    <table style="width: 100%">
        <tbody>
            <tr>
                <td>
                    <table style="background-color: #f6f7fb; width: 100%">
                        <tbody>
                            <tr>
                                <td>
                                    <table style="margin: 0 auto; margin-bottom: 30px">
                                        <tbody>
                                            <tr class="logo-sec" style="display: flex; align-items: center; justify-content: space-between; width: 650px;">
                                                <td>
                                                    <img src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="لوگو" style="height:48px;">
                                                </td>
                                                <td style="text-align: right; color:#999"><span>پرداخت موفق فاکتور</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table style="margin: 0 auto; background-color: #fff; border-radius: 8px">
                                        <tbody>
                                            <tr>
                                                <td style="padding: 30px">
                                                    <p>سلام <?php echo e($user->name ?? 'کاربر عزیز'); ?>،</p>
                                                    <p>پرداخت فاکتور شما با موفقیت انجام شد:</p>
                                                    <ul>
                                                        <li>شماره فاکتور: <?php echo e($invoice->id); ?></li>
                                                        <li>تاریخ پرداخت: <?php echo e($invoice->created_at->format('Y/m/d H:i')); ?></li>
                                                        <li>مبلغ: <?php echo e(number_format($invoice->amount)); ?> تومان</li>
                                                        <li>شماره تراکنش: <?php echo e($invoice->transaction_id ?? '-'); ?></li>
                                                    </ul>
                                                    <div class="text-center">
                                                        <a href="<?php echo e($panel_url ?? '#'); ?>"
                                                           style="padding: 10px 20px; background-color: #28a745; color: #fff; display: inline-block; border-radius: 4px; margin-bottom: 18px; text-decoration:none;">
                                                           مشاهده کیف پول
                                                        </a>
                                                    </div>
                                                    <p>با تشکر بابت اعتماد شما به OnHost!</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table style="margin: 0 auto; margin-top: 30px">
                                        <tbody>
                                            <tr style="text-align: center">
                                                <td>
                                                    <p style="color: #999; margin-bottom: 0">عدم تمایل به دریافت ایمیل؟ <a href="#" style="color: #7366ff">لغو عضویت</a></p>
                                                    <p style="color: #999; margin-bottom: 0">OnHost Cloud Platform</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
</body>
</html><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/emails/invoice_paid.blade.php ENDPATH**/ ?>