<?php $__env->startSection('title', 'کیف پول'); ?>

<?php $__env->startSection('css'); ?>
<style>
.sidebar-panel-main { display: none !important; }

/* استایل تب‌ها */
.wallet-tabs {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 2rem;
}

.wallet-tabs .nav-link {
    color: #6c757d;
    border: none;
    border-bottom: 3px solid transparent;
    padding: 1rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
}

.wallet-tabs .nav-link:hover {
    color: #0d6efd;
    background-color: #f8f9fa;
}

.wallet-tabs .nav-link.active {
    color: #0d6efd;
    border-bottom-color: #0d6efd;
    background-color: transparent;
}

/* کارت آمار */
.stats-card {
    border-left: 4px solid;
    transition: transform 0.2s;
}

.stats-card:hover {
    transform: translateY(-5px);
}

.stats-card.balance { border-left-color: #0d6efd; }
.stats-card.deposits { border-left-color: #198754; }
.stats-card.costs { border-left-color: #dc3545; }

/* بهبود جدول تراکنش‌ها */
.transaction-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    margin: 0 auto;
}

.transaction-icon.deposit { background-color: #d1e7dd; color: #198754; }
.transaction-icon.withdrawal { background-color: #f8d7da; color: #dc3545; }

/* Badge های بهتر */
.badge-lg {
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
}
/* استایل اضافه برای بخش گیفت کد */
#giftCodeInput {
    font-family: 'Courier New', monospace;
    font-weight: bold;
    letter-spacing: 2px;
}

.spin {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="wallet-charge-wrapper py-5" style="background: #f5f8fd; min-height: 100vh;">
    <div class="container">
        <!-- Header با موجودی -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h3 class="mb-2">
                                    <i class="ri-wallet-3-line text-primary"></i>
                                    کیف پول
                                </h3>
                                <p class="text-muted mb-0">مدیریت موجودی و تراکنش‌های مالی</p>
                            </div>
                            <div class="col-md-4 text-md-end">
                                <div class="balance-display">
                                    <small class="text-muted d-block">موجودی فعلی</small>
                                    <h2 class="mb-0 text-primary">
                                        <?php echo e(number_format($wallet_balance ?? 0)); ?>

                                        <small class="fs-6">تومان</small>
                                    </h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تب‌ها -->
        <ul class="nav nav-tabs wallet-tabs" id="walletTabs" role="tablist">
            <li class="nav-item" role="presentation">
        <button class="nav-link <?php echo e((!isset($activeTab) || $activeTab == 'charge') ? 'active' : ''); ?>" 
                id="charge-tab" 
                data-bs-toggle="tab" 
                data-bs-target="#charge" 
                type="button" 
                role="tab">
            <i class="ri-add-circle-line me-2"></i>
            شارژ کیف پول
        </button>
            </li>
            <li class="nav-item" role="presentation">
        <button class="nav-link <?php echo e((isset($activeTab) && $activeTab == 'transactions') ? 'active' : ''); ?>" 
                id="transactions-tab" 
                data-bs-toggle="tab" 
                data-bs-target="#transactions" 
                type="button" 
                role="tab">
            <i class="ri-file-list-3-line me-2"></i>
            ریز تراکنش‌ها
        </button>
            </li>
            <li class="nav-item" role="presentation">
        <button class="nav-link <?php echo e((isset($activeTab) && $activeTab == 'invoices') ? 'active' : ''); ?>" 
                id="invoices-tab" 
                data-bs-toggle="tab" 
                data-bs-target="#invoices" 
                type="button" 
                role="tab">
            <i class="ri-bill-line me-2"></i>
            فاکتورها
        </button>
            </li>
        </ul>

        <!-- محتوای تب‌ها -->
        <div class="tab-content" id="walletTabContent">
            
            
               <div class="tab-pane fade <?php echo e((!isset($activeTab) || $activeTab == 'charge') ? 'show active' : ''); ?>" 
         id="charge" 
         role="tabpanel">
                <div class="row justify-content-center">
                    <!-- فرم شارژ -->
                    <div class="col-lg-6 col-md-7 mb-4">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h5 class="mb-4 text-center">
                                    <i class="ri-money-euro-box-line"></i> 
                                    افزایش موجودی
                                </h5>
                                
                                <?php if(session('success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show">
                                        <i class="ri-checkbox-circle-line me-2"></i>
                                        <?php echo e(session('success')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if(session('danger')): ?>
                                    <div class="alert alert-danger alert-dismissible fade show">
                                        <i class="ri-error-warning-line me-2"></i>
                                        <?php echo e(session('danger')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div><i class="ri-error-warning-line me-1"></i><?php echo e($err); ?></div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <form action="<?php echo e(route('wallet.charge')); ?>" method="POST" autocomplete="off">
                                    <?php echo csrf_field(); ?>
                                    <div class="mb-3">
                                        <label for="amount" class="form-label">مبلغ شارژ (تومان)</label>
                                        <input id="amount" name="amount" type="number" min="20000" step="20000"
                                               class="form-control form-control-lg" value="20000" required />
                                        <small class="text-muted">حداقل مبلغ شارژ: 20,000 تومان</small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">روش پرداخت</label>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="method" 
                                                   value="bank" id="methodBank" checked>
                                            <label class="form-check-label" for="methodBank">
                                                <i class="ri-bank-card-line me-1"></i>
                                                درگاه بانکی (شاپرک)
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="alert alert-warning">
                                        <i class="ri-information-line me-2"></i>
                                        <strong>توجه:</strong> مبلغ شارژ قابل بازگشت نمی‌باشد.
                                    </div>
                                    
                                    <div class="d-grid gap-2">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="ri-shopping-cart-line me-2"></i>
                                            ادامه و صدور فاکتور
                                        </button>
                                    </div>
                                </form>
                                
                                                           <!-- 🎁 بخش کد هدیه -->
                                <div class="mt-4">
                                    <div class="text-center mb-3">
                                        <span class="text-muted">یا</span>
                                    </div>
                                    
                                    <div class="card bg-light border-0">
                                        <div class="card-body">
                                            <h6 class="text-center mb-3">
                                                <i class="ri-gift-line text-warning"></i>
                                                کد هدیه دارید؟
                                            </h6>
                                            
                                            <form id="giftCodeForm">
                                                <?php echo csrf_field(); ?>
                                                <div class="input-group">
                                                    <input type="text" 
                                                           class="form-control" 
                                                           id="giftCodeInput" 
                                                           placeholder="کد هدیه را وارد کنید (مثال: FIRST)"
                                                           style="text-transform: uppercase;">
                                                    <button class="btn btn-warning" type="submit" id="applyGiftCodeBtn">
                                                        <span class="default-text">
                                                            <i class="ri-check-line me-1"></i>
                                                            اعمال
                                                        </span>
                                                        <span class="loading-text d-none">
                                                            <i class="ri-loader-4-line spin"></i>
                                                        </span>
                                                    </button>
                                                </div>
                                                
                                                <!-- پیام نتیجه -->
                                                <div id="giftCodeMessage" class="mt-3" style="display: none;"></div>
                                            </form>
                                            
                                            <!-- نکات -->
                                            <div class="mt-3">
                                                <small class="text-muted">
                                                    <i class="ri-information-line me-1"></i>
                                                    کدهای هدیه فقط یک بار قابل استفاده هستند.
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                                
                    
                    <!-- اطلاعات پرداخت -->
                    <div class="col-lg-4 col-md-5 mb-4">
                        <div class="card shadow-sm h-100">
                            <div class="card-body">
                                <h6 class="mb-3">
                                    <i class="ri-secure-payment-line me-2"></i>
                                    روش‌های پرداخت
                                </h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex align-items-center">
                                        <i class="ri-bank-card-line text-primary fs-4 me-3"></i>
                                        <div>
                                            <strong>درگاه بانکی</strong>
                                            <small class="d-block text-muted">پرداخت امن از طریق شاپرک</small>
                                        </div>
                                    </li>
                                </ul>
                                
                                <div class="mt-4 p-3 bg-light rounded">
                                    <small class="text-muted">
                                        <i class="ri-shield-check-line text-success me-1"></i>
                                        تمامی تراکنش‌ها با استاندارد PCI-DSS محافظت می‌شوند
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="tab-pane fade <?php echo e((isset($activeTab) && $activeTab == 'transactions') ? 'show active' : ''); ?>" 
         id="transactions" 
         role="tabpanel">
                <div class="row mb-4">
                    <!-- آمار سریع -->
                    <div class="col-md-4 mb-3">
                        <div class="card stats-card balance shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <h6 class="text-muted mb-2">موجودی فعلی</h6>
                                        <h4 class="mb-0 text-primary"><?php echo e(number_format($wallet_balance ?? 0)); ?></h4>
                                        <small class="text-muted">تومان</small>
                                    </div>
                                    <div class="icon">
                                        <i class="ri-wallet-3-line fs-1 text-primary opacity-25"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <div class="card stats-card deposits shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <h6 class="text-muted mb-2">واریزی این ماه</h6>
                                        <h4 class="mb-0 text-success" id="monthlyDeposits">0</h4>
                                        <small class="text-muted">تومان</small>
                                    </div>
                                    <div class="icon">
                                        <i class="ri-arrow-down-circle-line fs-1 text-success opacity-25"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <div class="card stats-card costs shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <h6 class="text-muted mb-2">هزینه این ماه</h6>
                                        <h4 class="mb-0 text-danger" id="monthlyCosts">0</h4>
                                        <small class="text-muted">تومان</small>
                                    </div>
                                    <div class="icon">
                                        <i class="ri-arrow-up-circle-line fs-1 text-danger opacity-25"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- فیلترها -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('wallet.transactions')); ?>" id="filterForm">
                            <div class="row g-3 align-items-end">
                                <div class="col-md-3">
                                    <label class="form-label">از تاریخ</label>
                                    <input type="date" name="from" class="form-control" 
                                           value="<?php echo e(request('from', now()->startOfMonth()->format('Y-m-d'))); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">تا تاریخ</label>
                                    <input type="date" name="to" class="form-control" 
                                           value="<?php echo e(request('to', now()->format('Y-m-d'))); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">نوع تراکنش</label>
                                    <select name="type" class="form-select">
                                        <option value="">همه</option>
                                        <option value="deposit">واریز</option>
                                        <option value="server_hourly">هزینه سرور</option>
                                        <option value="ip_hourly">هزینه IP</option>
                                        <option value="bandwidth_overage">اضافه ترافیک</option>
                                        <option value="refund">بازگشت وجه</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="ri-search-line me-2"></i>
                                        جستجو
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- جدول تراکنش‌ها -->
                <div class="card shadow-sm">
                    <div class="card-header bg-white">
                        <h6 class="mb-0">
                            <i class="ri-file-list-3-line me-2"></i>
                            لیست تراکنش‌ها
                        </h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-center" style="width: 60px;">نوع</th>
                                        <th>شرح</th>
                                        <th class="text-center">تاریخ و زمان</th>
                                        <th class="text-end">مبلغ</th>
                                        <th class="text-center">موجودی بعد</th>
                                        <th class="text-center">وضعیت</th>
                                    </tr>
                                </thead>
                                <tbody id="transactionsTableBody">
                                    <tr>
                                        <td colspan="6" class="text-center py-5">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">در حال بارگذاری...</span>
                                            </div>
                                            <p class="mt-3 text-muted">در حال دریافت تراکنش‌ها...</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer bg-white" id="paginationContainer"></div>
                </div>
            </div>

            
            <div class="tab-pane fade <?php echo e((isset($activeTab) && $activeTab == 'invoices') ? 'show active' : ''); ?>" 
         id="invoices" 
         role="tabpanel">
                <div class="card shadow-sm">
                    <div class="card-header bg-white">
                        <h6 class="mb-0">
                            <i class="ri-bill-line me-2"></i>
                            لیست فاکتورهای شارژ
                        </h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>شماره فاکتور</th>
                                        <th>مبلغ</th>
                                        <th>روش پرداخت</th>
                                        <th>وضعیت</th>
                                        <th>تاریخ</th>
                                        <th class="text-center">عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <strong>#<?php echo e($invoice->id); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e(number_format($invoice->amount)); ?></strong>
                                                <small class="text-muted">تومان</small>
                                            </td>
                                            <td>
                                                <?php if($invoice->method == 'bank'): ?>
                                                    <i class="ri-bank-card-line me-1"></i> درگاه بانکی
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($invoice->status == 'pending'): ?>
                                                    <span class="badge bg-warning">
                                                        <i class="ri-time-line me-1"></i>
                                                        در انتظار پرداخت
                                                    </span>
                                                <?php elseif($invoice->status == 'paid'): ?>
                                                    <span class="badge bg-success">
                                                        <i class="ri-checkbox-circle-line me-1"></i>
                                                        پرداخت شده
                                                    </span>
                                                <?php elseif($invoice->status == 'unpaid'): ?>
                                                    <span class="badge bg-danger">
                                                        <i class="ri-close-circle-line me-1"></i>
                                                        پرداخت نشده
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">لغو شده</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                              <small><?php echo e($invoice->created_at->format('Y/m/d H:i')); ?></small>
                                            </td>
                                            <td class="text-center">
                                                <?php if($invoice->status == 'pending' && $invoice->method == 'bank'): ?>
                                                    <a href="<?php echo e(route('wallet.zibal.pay', $invoice->id)); ?>" 
                                                       class="btn btn-sm btn-primary">
                                                        <i class="ri-money-dollar-circle-line me-1"></i>
                                                        پرداخت
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <i class="ri-file-list-line fs-1 text-muted mb-3 d-block"></i>
                                                <p class="text-muted mb-0">هنوز فاکتوری ثبت نشده است</p>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<!-- ✅ Confetti Library -->
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.0/dist/confetti.browser.min.js"></script>

<script>
// ==================== بارگذاری تراکنش‌ها با AJAX ====================
document.addEventListener('DOMContentLoaded', function() {
    const transactionsTab = document.getElementById('transactions-tab');
    
    if (transactionsTab) {
        // هنگام کلیک روی تب تراکنش‌ها
        transactionsTab.addEventListener('shown.bs.tab', function() {
            loadTransactions();
        });
    }
    
    // اگر از URL تب transactions فعال شده
    const urlParams = new URLSearchParams(window.location.search);
    const activeTab = urlParams.get('tab');
    
    if (activeTab === 'transactions') {
        if (transactionsTab) {
            const tab = new bootstrap.Tab(transactionsTab);
            tab.show();
            loadTransactions();
        }
    }
    
    // اگر hash در URL باشه
    const hash = window.location.hash;
    if (hash === '#transactions' && transactionsTab) {
        const tab = new bootstrap.Tab(transactionsTab);
        tab.show();
        loadTransactions();
    }
    
    // فرم فیلتر
    const filterForm = document.getElementById('filterForm');
    if (filterForm) {
        filterForm.addEventListener('submit', function(e) {
            e.preventDefault();
            loadTransactions(1);
        });
    }
});


document.addEventListener('DOMContentLoaded', function() {
    const giftCodeForm = document.getElementById('giftCodeForm');
    const giftCodeInput = document.getElementById('giftCodeInput');
    const applyBtn = document.getElementById('applyGiftCodeBtn');
    const messageDiv = document.getElementById('giftCodeMessage');
    
    // تبدیل به حروف بزرگ هنگام تایپ
    giftCodeInput.addEventListener('input', function() {
        this.value = this.value.toUpperCase();
    });
    
    giftCodeForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const code = giftCodeInput.value.trim();
        
        if (!code) {
            showMessage('لطفاً کد هدیه را وارد کنید.', 'warning');
            return;
        }
        
        // نمایش لودینگ
        applyBtn.disabled = true;
        applyBtn.querySelector('.default-text').classList.add('d-none');
        applyBtn.querySelector('.loading-text').classList.remove('d-none');
        messageDiv.style.display = 'none';
        
        // ارسال درخواست
        fetch('<?php echo e(route("wallet.giftcode.apply")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || 
                                document.querySelector('input[name="_token"]')?.value
            },
            body: JSON.stringify({ code: code })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                showMessage(data.message, 'success');
                
                // بروزرسانی موجودی در صفحه
                const balanceElements = document.querySelectorAll('.balance-display h2');
                balanceElements.forEach(el => {
                    el.innerHTML = data.new_balance.toLocaleString('fa-IR') + 
                                   ' <small class="fs-6">تومان</small>';
                });
                
                // پاک کردن input
                giftCodeInput.value = '';
                
                // نمایش انیمیشن موفقیت
                confetti({
                    particleCount: 100,
                    spread: 70,
                    origin: { y: 0.6 }
                });
            } else {
                showMessage(data.message, 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('خطا در اعمال کد هدیه. لطفاً دوباره تلاش کنید.', 'danger');
        })
        .finally(() => {
            // برگرداندن حالت دکمه
            applyBtn.disabled = false;
            applyBtn.querySelector('.default-text').classList.remove('d-none');
            applyBtn.querySelector('.loading-text').classList.add('d-none');
        });
    });
    
    function showMessage(message, type) {
        messageDiv.innerHTML = `
            <div class="alert alert-${type} alert-dismissible fade show mb-0" role="alert">
                <i class="ri-${type === 'success' ? 'checkbox-circle' : type === 'warning' ? 'alert' : 'error-warning'}-line me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        messageDiv.style.display = 'block';
        
        // پاک کردن خودکار بعد از 5 ثانیه
        if (type === 'success') {
            setTimeout(() => {
                messageDiv.style.display = 'none';
            }, 5000);
        }
    }
});

/**
 * بارگذاری تراکنش‌ها
 */
function loadTransactions(page = 1) {
    const tbody = document.getElementById('transactionsTableBody');
    if (!tbody) return;

    // دریافت مقادیر فیلتر
    let from = document.querySelector('input[name="from"]')?.value;
    let to = document.querySelector('input[name="to"]')?.value;
    let type = document.querySelector('select[name="type"]')?.value || '';
    
    // اگر از input نگرفتیم، از URL بگیر
    if (!from || !to) {
        const urlParams = new URLSearchParams(window.location.search);
        from = from || urlParams.get('from') || '<?php echo e(now()->startOfMonth()->format("Y-m-d")); ?>';
        to = to || urlParams.get('to') || '<?php echo e(now()->format("Y-m-d")); ?>';
    }
    
    // نمایش لودینگ
    tbody.innerHTML = `
        <tr>
            <td colspan="6" class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">در حال بارگذاری...</span>
                </div>
                <p class="mt-3 text-muted">در حال بارگذاری تراکنش‌ها...</p>
            </td>
        </tr>
    `;
    
    // ساخت URL
    const url = new URL('<?php echo e(route("wallet.transactions")); ?>', window.location.origin);
    url.searchParams.set('from', from);
    url.searchParams.set('to', to);
    if (type) url.searchParams.set('type', type);
    url.searchParams.set('page', page);
    
    console.log('Loading transactions from:', url.toString());
    
    // درخواست AJAX
    fetch(url, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => {
        console.log('Response status:', response.status);
        if (!response.ok) {
            throw new Error('Network response was not ok: ' + response.status);
        }
        return response.json();
    })
    .then(data => {
        console.log('Data received:', data);
        
        if (data.success) {
            renderTransactions(data.transactions || []);
            renderPagination(data.pagination || {});
            updateStats(data.stats || {});
        } else {
            throw new Error(data.message || 'خطا در دریافت داده‌ها');
        }
    })
    .catch(error => {
        console.error('Error loading transactions:', error);
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center py-5 text-danger">
                    <i class="ri-error-warning-line fs-1 mb-2 d-block"></i>
                    <p class="mb-2">خطا در بارگذاری تراکنش‌ها</p>
                    <small class="text-muted d-block mb-3">${error.message}</small>
                    <button class="btn btn-sm btn-primary" onclick="loadTransactions()">
                        <i class="ri-refresh-line me-1"></i>
                        تلاش مجدد
                    </button>
                </td>
            </tr>
        `;
    });
}

/**
 * رندر کردن تراکنش‌ها در جدول
 */
function renderTransactions(transactions) {
    const tbody = document.getElementById('transactionsTableBody');
    
    if (!transactions || transactions.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center py-5">
                    <i class="ri-file-list-line fs-1 text-muted mb-3 d-block"></i>
                    <p class="text-muted mb-2">تراکنشی یافت نشد</p>
                    <small class="text-muted">برای فیلتر دیگری امتحان کنید یا بازه زمانی را تغییر دهید</small>
                </td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = transactions.map(tx => {
        const isDeposit = tx.is_deposit || tx.amount > 0;
        const icon = getTransactionIcon(tx.type);
        const amountClass = isDeposit ? 'text-success' : 'text-danger';
        const amountSign = isDeposit ? '+' : '';
        
        return `
            <tr>
                <td class="text-center">
                    <div class="transaction-icon ${isDeposit ? 'deposit' : 'withdrawal'}">
                        <i class="${icon}"></i>
                    </div>
                </td>
                <td>
                    <strong>${tx.type_label || '-'}</strong>
                    <small class="d-block text-muted">${tx.description || '-'}</small>
                </td>
                <td class="text-center">
                    <small>${tx.created_at || '-'}</small>
                    <br>
                    <small class="text-muted">${tx.created_at_human || ''}</small>
                </td>
                <td class="text-end">
                    <strong class="${amountClass}">${amountSign}${tx.amount_formatted || '0'}</strong>
                </td>
                <td class="text-center">
                    <small>${tx.balance_after_formatted || '0'}</small>
                </td>
                <td class="text-center">
                    <span class="badge bg-${tx.status_class || 'secondary'}">${tx.status_label || '-'}</span>
                </td>
            </tr>
        `;
    }).join('');
}

/**
 * دریافت آیکون مناسب برای هر نوع تراکنش
 */
function getTransactionIcon(type) {
    const icons = {
        'deposit': 'ri-add-circle-line',
        'server_hourly': 'ri-server-line',
        'ip_hourly': 'ri-global-line',
        'server_create': 'ri-add-box-line',
        'ip_create': 'ri-router-line',
        'bandwidth_overage': 'ri-speed-line',
        'refund': 'ri-refund-2-line',
        'bonus': 'ri-gift-line',
        'penalty': 'ri-alert-line'
    };
    return icons[type] || 'ri-money-dollar-circle-line';
}

/**
 * رندر کردن صفحه‌بندی
 */
function renderPagination(pagination) {
    const container = document.getElementById('paginationContainer');
    if (!container) return;
    
    if (!pagination || pagination.last_page <= 1) {
        container.innerHTML = '';
        return;
    }
    
    let html = '<nav aria-label="صفحه‌بندی تراکنش‌ها">';
    html += '<ul class="pagination pagination-sm justify-content-center mb-0">';
    
    // دکمه قبلی
    if (pagination.current_page > 1) {
        html += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadTransactions(${pagination.current_page - 1}); return false;">
                    <i class="ri-arrow-right-s-line"></i>
                </a>
            </li>
        `;
    }
    
    // صفحات
    const maxPages = 5;
    let startPage = Math.max(1, pagination.current_page - Math.floor(maxPages / 2));
    let endPage = Math.min(pagination.last_page, startPage + maxPages - 1);
    
    if (endPage - startPage < maxPages - 1) {
        startPage = Math.max(1, endPage - maxPages + 1);
    }
    
    if (startPage > 1) {
        html += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadTransactions(1); return false;">1</a>
            </li>
        `;
        if (startPage > 2) {
            html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
    }
    
    for (let i = startPage; i <= endPage; i++) {
        const active = i === pagination.current_page ? 'active' : '';
        html += `
            <li class="page-item ${active}">
                <a class="page-link" href="#" onclick="loadTransactions(${i}); return false;">${i}</a>
            </li>
        `;
    }
    
    if (endPage < pagination.last_page) {
        if (endPage < pagination.last_page - 1) {
            html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
        html += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadTransactions(${pagination.last_page}); return false;">${pagination.last_page}</a>
            </li>
        `;
    }
    
    // دکمه بعدی
    if (pagination.current_page < pagination.last_page) {
        html += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadTransactions(${pagination.current_page + 1}); return false;">
                    <i class="ri-arrow-left-s-line"></i>
                </a>
            </li>
        `;
    }
    
    html += '</ul>';
    html += `<p class="text-center text-muted mt-2 mb-0 small">صفحه ${pagination.current_page} از ${pagination.last_page} (مجموع: ${pagination.total} تراکنش)</p>`;
    html += '</nav>';
    
    container.innerHTML = html;
}

/**
 * بروزرسانی آمار
 */
function updateStats(stats) {
    const depositEl = document.getElementById('monthlyDeposits');
    const costEl = document.getElementById('monthlyCosts');
    
    if (depositEl) {
        const deposits = stats.total_deposits || 0;
        depositEl.textContent = stats.total_deposits_formatted || (deposits.toLocaleString('fa-IR') + ' تومان');
    }
    
    if (costEl) {
        const costs = stats.total_costs || 0;
        costEl.textContent = stats.total_costs_formatted || (costs.toLocaleString('fa-IR') + ' تومان');
    }
    
    // لاگ برای debug
    console.log('Stats updated:', stats);
}

// ==================== اعتبارسنجی فرم شارژ ====================
const amountInput = document.getElementById('amount');
if (amountInput) {
    amountInput.addEventListener('input', function() {
        const value = parseInt(this.value);
        if (isNaN(value) || value < 10000) {
            this.setCustomValidity('حداقل مبلغ شارژ 2۰,۰۰۰ تومان است.');
        } else if (value > 5000000) {
            this.setCustomValidity('حداکثر مبلغ شارژ ۵,۰۰۰,۰۰۰ تومان است.');
        } else {
            this.setCustomValidity('');
        }
    });
    
    amountInput.addEventListener('invalid', function() {
        const value = parseInt(this.value);
        if (isNaN(value) || value < 20000) {
            this.setCustomValidity('حداقل مبلغ شارژ 20,000 تومان است.');
        } else if (value > 5000000) {
            this.setCustomValidity('حداکثر مبلغ شارژ ۵,۰۰۰,۰۰۰ تومان است.');
        }
    });
}

// ==================== نمایش/مخفی کردن فیلترها ====================
const toggleFilterBtn = document.getElementById('toggleFilterBtn');
const filterSection = document.getElementById('filterSection');

if (toggleFilterBtn && filterSection) {
    toggleFilterBtn.addEventListener('click', function() {
        filterSection.classList.toggle('d-none');
        const icon = this.querySelector('i');
        if (filterSection.classList.contains('d-none')) {
            icon.classList.remove('ri-arrow-up-s-line');
            icon.classList.add('ri-arrow-down-s-line');
        } else {
            icon.classList.remove('ri-arrow-down-s-line');
            icon.classList.add('ri-arrow-up-s-line');
        }
    });
}

// ==================== ریست فیلتر ====================
function resetFilters() {
    const today = new Date();
    const firstDay = new Date(today.getFullYear(), today.getMonth(), 1);
    
    const fromInput = document.querySelector('input[name="from"]');
    const toInput = document.querySelector('input[name="to"]');
    const typeSelect = document.querySelector('select[name="type"]');
    
    if (fromInput) fromInput.value = firstDay.toISOString().split('T')[0];
    if (toInput) toInput.value = today.toISOString().split('T')[0];
    if (typeSelect) typeSelect.value = '';
    
    loadTransactions(1);
}

// ==================== Export تراکنش‌ها (آپشنال) ====================
function exportTransactions(format = 'csv') {
    const from = document.querySelector('input[name="from"]')?.value || '<?php echo e(now()->startOfMonth()->format("Y-m-d")); ?>';
    const to = document.querySelector('input[name="to"]')?.value || '<?php echo e(now()->format("Y-m-d")); ?>';
    const type = document.querySelector('select[name="type"]')?.value || '';
    
    const url = `/wallet/transactions/export?format=${format}&from=${from}&to=${to}&type=${type}`;
    window.location.href = url;
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.simple.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/wallet-charge.blade.php ENDPATH**/ ?>