<?php $__env->startSection('css'); ?>
<style>
    :root {
        --purple-primary: #7c3aed;
        --purple-secondary: #a78bfa;
        --purple-light: #ede9fe;
        --gradient-purple: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .limits-container {
        padding: 1.5rem 0;
    }

    /* Page Header */
    .page-header {
        margin-bottom: 1.5rem;
    }

    .page-header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }

    .page-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.25rem;
        display: flex;
        align-items: center;
    }

    .page-subtitle {
        color: #6b7280;
        font-size: 0.875rem;
        margin: 0;
    }

    /* Summary Card - کوچک شده */
    .summary-card {
        background: var(--gradient-purple);
        border-radius: 16px;
        padding: 1.25rem;
        color: white;
        margin-bottom: 1.5rem;
        box-shadow: 0 4px 15px rgba(124, 58, 237, 0.25);
    }

    .summary-title {
        font-size: 1rem;
        font-weight: 700;
        margin-bottom: 0.75rem;
        display: flex;
        align-items: center;
    }

    .summary-stats {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 1rem;
    }

    .summary-item {
        text-align: center;
    }

    .summary-value {
        font-size: 1.75rem;
        font-weight: 700;
        margin-bottom: 0.25rem;
        line-height: 1;
    }

    .summary-label {
        font-size: 0.8rem;
        opacity: 0.9;
    }

    /* Limit Cards - دو ستونه */
    .limit-card {
        background: white;
        border-radius: 16px;
        padding: 1.25rem;
        margin-bottom: 1rem;
        box-shadow: 0 2px 10px rgba(124, 58, 237, 0.08);
        border: 1px solid rgba(124, 58, 237, 0.1);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }

    .limit-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        background: var(--gradient-purple);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s ease;
    }

    .limit-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(124, 58, 237, 0.12);
    }

    .limit-card:hover::before {
        transform: scaleX(1);
    }

    /* Card Header - کوچک‌تر */
    .limit-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1rem;
    }

    .limit-icon-wrapper {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        background: var(--gradient-purple);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        color: white;
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.25);
        flex-shrink: 0;
    }

    .limit-info {
        flex-grow: 1;
        margin-left: 1rem;
    }

    .limit-title {
        font-size: 0.95rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.15rem;
    }

    .limit-description {
        font-size: 0.75rem;
        color: #6b7280;
    }

    .limit-stats {
        text-align: left;
    }

    .limit-current {
        font-size: 1.5rem;
        font-weight: 700;
        background: var(--gradient-purple);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        line-height: 1;
    }

    .limit-max {
        font-size: 0.75rem;
        color: #6b7280;
        margin-top: 0.15rem;
    }

    /* Progress Bar - کوچک‌تر */
    .progress-wrapper {
        position: relative;
        margin-bottom: 0.5rem;
    }

    .progress-bar-custom {
        height: 8px;
        background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
        border-radius: 8px;
        overflow: hidden;
        position: relative;
        box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
    }

    .progress-fill {
        height: 100%;
        border-radius: 8px;
        transition: width 1s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }

    .progress-fill::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        background: linear-gradient(
            90deg,
            rgba(255,255,255,0) 0%,
            rgba(255,255,255,0.3) 50%,
            rgba(255,255,255,0) 100%
        );
        animation: shimmer 2s infinite;
    }

    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }

    /* Progress Colors */
    .progress-success {
        background: linear-gradient(135deg, #34d399 0%, #10b981 100%);
        box-shadow: 0 2px 6px rgba(16, 185, 129, 0.25);
    }

    .progress-warning {
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        box-shadow: 0 2px 6px rgba(245, 158, 11, 0.25);
    }

    .progress-danger {
        background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
        box-shadow: 0 2px 6px rgba(239, 68, 68, 0.25);
    }

    /* Progress Info */
    .progress-info {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.75rem;
    }

    .progress-percentage {
        font-weight: 700;
        color: #1f2937;
    }

    .progress-remaining {
        color: #6b7280;
    }

    /* Status Badge - کوچک‌تر */
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.4rem;
        padding: 0.35rem 0.75rem;
        border-radius: 8px;
        font-size: 0.7rem;
        font-weight: 600;
    }

    .status-safe {
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        color: #065f46;
    }

    .status-moderate {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
    }

    .status-critical {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #991b1b;
    }

    .status-icon {
        font-size: 0.85rem;
    }

    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .limit-card {
        animation: fadeInUp 0.5s ease-out forwards;
    }

    .limit-card:nth-child(1) { animation-delay: 0.05s; }
    .limit-card:nth-child(2) { animation-delay: 0.1s; }
    .limit-card:nth-child(3) { animation-delay: 0.15s; }
    .limit-card:nth-child(4) { animation-delay: 0.2s; }

    /* Responsive */
    @media (max-width: 992px) {
        .summary-stats {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 768px) {
        .page-header-content {
            flex-direction: column;
            align-items: flex-start;
        }

        .summary-stats {
            grid-template-columns: repeat(2, 1fr);
        }

        .limit-header {
            flex-wrap: wrap;
        }

        .limit-stats {
            width: 100%;
            text-align: right;
            margin-top: 0.5rem;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="limits-container">
                
          
            <div class="d-flex justify-content-between align-items-center mb-4 ">
                
                          <h3 class="page-title mb-0">
                        <i class="ri-ip-line me-2"></i>
                     محدودیت ها
                    </h3>
                    <p class="page-subtitle">محدودیت های حساب کاربری شما</p>
                </div>
                    </div>
                </div>

                <!-- Summary Card - کوچک شده -->
                <div class="summary-card">
                    <div class="summary-title">
                        <i class="ri-dashboard-line me-2"></i>
                        خلاصه وضعیت
                    </div>
                    <div class="summary-stats">
                        <div class="summary-item">
                            <div class="summary-value"><?php echo e($usage['projects'] ?? 0); ?>/<?php echo e($limits['projects'] ?? 5); ?></div>
                            <div class="summary-label">پروژه‌ها</div>
                        </div>
                        <div class="summary-item">
                            <div class="summary-value"><?php echo e($usage['servers'] ?? 0); ?>/<?php echo e($limits['servers'] ?? 5); ?></div>
                            <div class="summary-label">سرورها</div>
                        </div>
                        <div class="summary-item">
                            <div class="summary-value"><?php echo e($usage['ips'] ?? 0); ?>/<?php echo e($limits['ips'] ?? 10); ?></div>
                            <div class="summary-label">آی‌پی‌ها</div>
                        </div>
                        <div class="summary-item">
                            <div class="summary-value"><?php echo e($usage['deletions'] ?? 0); ?>/<?php echo e($limits['deletions'] ?? 15); ?></div>
                            <div class="summary-label">حذف‌ها</div>
                        </div>
                    </div>
                </div>

                <!-- دو ستونه شده -->
                <div class="row">
                    
                    <!-- Projects Limit -->
                    <div class="col-lg-6">
                        <div class="limit-card">
                            <div class="limit-header">
                                <div class="limit-icon-wrapper">
                                    <i class="ri-folder-3-line"></i>
                                </div>
                                <div class="limit-info">
                                    <div class="limit-title">پروژه‌ها</div>
                                    <div class="limit-description">تعداد پروژه‌های قابل ایجاد</div>
                                </div>
                                <div class="limit-stats">
                                    <div class="limit-current"><?php echo e($usage['projects'] ?? 2); ?></div>
                                    <div class="limit-max">از <?php echo e($limits['projects'] ?? 5); ?></div>
                                </div>
                            </div>
                            <div class="progress-wrapper">
                                <div class="progress-bar-custom">
                                    <div class="progress-fill progress-success" 
                                         style="width: <?php echo e((($usage['projects'] ?? 2) / ($limits['projects'] ?? 5)) * 100); ?>%">
                                    </div>
                                </div>
                            </div>
                            <div class="progress-info">
                                <span class="progress-percentage">
                                    <?php echo e(round((($usage['projects'] ?? 2) / ($limits['projects'] ?? 5)) * 100)); ?>% استفاده شده
                                </span>
                                <span class="progress-remaining">
                                    <?php echo e(($limits['projects'] ?? 5) - ($usage['projects'] ?? 2)); ?> باقی‌مانده
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Servers Limit -->
                    <div class="col-lg-6">
                        <div class="limit-card">
                            <div class="limit-header">
                                <div class="limit-icon-wrapper">
                                    <i class="ri-server-line"></i>
                                </div>
                                <div class="limit-info">
                                    <div class="limit-title">سرورها</div>
                                    <div class="limit-description">تعداد سرورهای قابل ایجاد</div>
                                </div>
                                <div class="limit-stats">
                                    <div class="limit-current"><?php echo e($usage['servers'] ?? 3); ?></div>
                                    <div class="limit-max">از <?php echo e($limits['servers'] ?? 5); ?></div>
                                </div>
                            </div>
                            <div class="progress-wrapper">
                                <div class="progress-bar-custom">
                                    <div class="progress-fill progress-warning" 
                                         style="width: <?php echo e((($usage['servers'] ?? 3) / ($limits['servers'] ?? 5)) * 100); ?>%">
                                    </div>
                                </div>
                            </div>
                            <div class="progress-info">
                                <span class="progress-percentage">
                                    <?php echo e(round((($usage['servers'] ?? 3) / ($limits['servers'] ?? 5)) * 100)); ?>% استفاده شده
                                </span>
                                <span class="progress-remaining">
                                    <?php echo e(($limits['servers'] ?? 5) - ($usage['servers'] ?? 3)); ?> باقی‌مانده
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- IPs Limit -->
                    <div class="col-lg-6">
                        <div class="limit-card">
                            <div class="limit-header">
                                <div class="limit-icon-wrapper">
                                    <i class="ri-global-line"></i>
                                </div>
                                <div class="limit-info">
                                    <div class="limit-title">آی‌پی‌ها</div>
                                    <div class="limit-description">تعداد آدرس‌های IP قابل ایجاد</div>
                                </div>
                                <div class="limit-stats">
                                    <div class="limit-current"><?php echo e($usage['ips'] ?? 7); ?></div>
                                    <div class="limit-max">از <?php echo e($limits['ips'] ?? 10); ?></div>
                                </div>
                            </div>
                            <div class="progress-wrapper">
                                <div class="progress-bar-custom">
                                    <div class="progress-fill progress-warning" 
                                         style="width: <?php echo e((($usage['ips'] ?? 7) / ($limits['ips'] ?? 10)) * 100); ?>%">
                                    </div>
                                </div>
                            </div>
                            <div class="progress-info">
                                <span class="progress-percentage">
                                    <?php echo e(round((($usage['ips'] ?? 7) / ($limits['ips'] ?? 10)) * 100)); ?>% استفاده شده
                                </span>
                                <span class="progress-remaining">
                                    <?php echo e(($limits['ips'] ?? 10) - ($usage['ips'] ?? 7)); ?> باقی‌مانده
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Deletions Limit -->
                    <div class="col-lg-6">
                        <div class="limit-card">
                            <div class="limit-header">
                                <div class="limit-icon-wrapper">
                                    <i class="ri-delete-bin-line"></i>
                                </div>
                                <div class="limit-info">
                                    <div class="limit-title">تعداد حذف‌ها</div>
                                    <div class="limit-description">عملیات حذف در ماه جاری</div>
                                </div>
                                <div class="limit-stats">
                                    <div class="limit-current"><?php echo e($usage['deletions'] ?? 8); ?></div>
                                    <div class="limit-max">از <?php echo e($limits['deletions'] ?? 15); ?></div>
                                </div>
                            </div>
                            <div class="progress-wrapper">
                                <div class="progress-bar-custom">
                                    <div class="progress-fill progress-warning" 
                                         style="width: <?php echo e((($usage['deletions'] ?? 8) / ($limits['deletions'] ?? 15)) * 100); ?>%">
                                    </div>
                                </div>
                            </div>
                            <div class="progress-info">
                                <span class="progress-percentage">
                                    <?php echo e(round((($usage['deletions'] ?? 8) / ($limits['deletions'] ?? 15)) * 100)); ?>% استفاده شده
                                </span>
                                <span class="progress-remaining">
                                    <?php echo e(($limits['deletions'] ?? 15) - ($usage['deletions'] ?? 8)); ?> باقی‌مانده
                                </span>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    // انیمیشن پروگرس بارها
    document.addEventListener('DOMContentLoaded', function() {
        const progressFills = document.querySelectorAll('.progress-fill');
        
        progressFills.forEach((fill, index) => {
            const targetWidth = fill.style.width;
            fill.style.width = '0%';
            
            setTimeout(() => {
                fill.style.width = targetWidth;
            }, 200 + (index * 80));
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.simple.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/cloud/limits.blade.php ENDPATH**/ ?>