

<?php $__env->startSection('title', 'سرورهای پروژه'); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/select/bootstrap-select.min.css')); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" />
<link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
<style>
.sidebar-panel-main { display: none !important; }
/* اصلاح نمایش دراپ‌داون سرور */
.dropdown.dropdown-server .dropdown-toggle:focus,
.dropdown.dropdown-server .dropdown-toggle:active {
    border: none !important;
    outline: none !important;
}

/* === DROPDOWN SERVER MANAGER === */
.dropdown-server{position:relative;display:inline-block}.dropdown-server .dropdown-toggle{cursor:pointer;background: #fff !important;}.dropdown-server .dropdown-toggle::after{display:inline-block;margin-left:.3em;vertical-align:middle;content:"\f107";font-family:"Font Awesome 6 Free";font-weight:900;font-size:14px}.dropdown-server .dropdown-menu{display:none;position:absolute;z-index:2000;min-width:150px;box-shadow:0 2px 10px rgba(0,0,0,.07);background:#fff;border-radius:8px;border:1px solid #eee;opacity:1;transition:opacity .2s}.dropdown-server.show .dropdown-menu{display:block;opacity:1}.dropdown-server .dropdown-toggle:focus,.dropdown-server .dropdown-toggle:active{outline:none!important;box-shadow:none!important}.card-body,.table-responsive{overflow:visible!important}

/* سرور ساسپند شده: محو منو */
.server-suspended {
    opacity: 0.5;
    pointer-events: none;
    user-select: none;
}

/* حالت عادی */
.dropdown-menu {
    opacity: 1 !important;
    pointer-events: auto !important;
    background: #fff;
}

.server-suspended .dropdown-toggle {
    background: #f9f9f9 !important;
    color: #bbb !important;
    border-color: #eee !important;
}
.server-suspended .dropdown-menu {
    display: none !important;
}

.card-body,
.table-responsive {
    overflow: visible !important;
}

.progress { height: 20px; }
.progress-bar { font-size: 12px; line-height: 20px; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span class="card-title mb-0">فهرست سرورها</span>
                            <a href="<?php echo e(route('servers.create', $project->id)); ?>" class="btn btn-primary btn-sm">
                                <i class="ri-add-line align-bottom"></i> ایجاد سرور جدید
                            </a>
                        </div>

                        <div class="card-body">
                            <?php if($servers->isEmpty()): ?>
                                <div class="text-center p-4">
                                    <p class="mb-2">هیچ سروری وجود ندارد.</p>
                                    <a href="<?php echo e(route('servers.create', $project->id)); ?>" class="btn btn-primary">
                                        <i class="ri-add-line"></i> ایجاد سرور جدید
                                    </a>
                                </div>
                            <?php else: ?>
                                <table id="normal" class="table dt-responsive nowrap table-striped table-hover align-middle text-center" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>نام</th>
                                            <th>آی‌پی</th>
                                            <th>موقعیت</th>
                                            <th>وضعیت</th>
                                            <th>هزینه ساعتی</th>
                                            <th>تاریخ ایجاد</th>
                                            <th>اقدام</th>
                                        </tr>
                                    </thead>
                                    <tbody>
<?php $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $statusMap = [
            'active'        => ['title' => 'روشن', 'class' => 'border border-success text-success'],
            'ACTIVE'        => ['title' => 'روشن', 'class' => 'border border-success text-success'],           
            'running'       => ['title' => 'روشن', 'class' => 'border border-success text-success'],
            'on'            => ['title' => 'روشن', 'class' => 'border border-success text-success'],
            'starting'      => ['title' => 'در حال روشن شدن', 'class' => 'border border-warning text-warning'],
            'initializing'  => ['title' => 'در حال آماده‌سازی', 'class' => 'border border-warning text-warning'],
            'installing'    => ['title' => 'در حال نصب', 'class' => 'border border-warning text-warning'],
            'creating'      => ['title' => 'در حال آماده‌سازی', 'class' => 'border border-warning text-warning'],
            'pending'       => ['title' => 'در حال آماده سازی', 'class' => 'border border-warning text-warning'],
            'shutoff'       => ['title' => 'خاموش', 'class' => 'border border-secondary text-secondary'],
            'off'           => ['title' => 'خاموش', 'class' => 'border border-secondary text-secondary'],
            'stopped'       => ['title' => 'خاموش', 'class' => 'border border-secondary text-secondary'],
            'suspended'     => ['title' => 'مسدود (کمبود اعتبار)', 'class' => 'border border-danger text-danger'],
        ];
        $showStatus = isset($statusMap[$server->status]) ? $statusMap[$server->status]['title'] : 'نامشخص';
        $statusClass = isset($statusMap[$server->status]) ? $statusMap[$server->status]['class'] : 'border border-secondary text-secondary';
        $isActive = in_array($server->status, ['active', 'running', 'on']);
        $isOff = in_array($server->status, ['off', 'stopped']);
        $isInProgress = in_array($server->status, ['creating', 'pending', 'starting', 'initializing', 'installing']);
    ?>
    <tr id="server-<?php echo e($server->id); ?>" <?php if($server->status === 'suspended'): ?> class="server-suspended" <?php endif; ?>>
        <td>#<?php echo e($loop->iteration); ?></td>
        <td class="fw-bold">
            <?php echo e($server->name); ?>

            <?php if($server->provider === 'hetzner'): ?>
                <span class="badge bg-info ms-1">Hetzner</span>
            <?php elseif($server->provider === 'vultr'): ?>
                <span class="badge bg-primary ms-1">Vultr</span>
            <?php endif; ?>
        </td>
        <td id="server-ip-<?php echo e($server->id); ?>">
            <?php if($server->status === 'pending' || $server->status === 'creating'): ?>
                <div class="progress">
                    <div id="server-progress-<?php echo e($server->id); ?>" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: <?php echo e($server->progress ?? 0); ?>%;">
                        در حال آماده سازی (<?php echo e($server->progress ?? 0); ?>%)
                    </div>
                </div>
            <?php else: ?>
                <?php echo e($server->ip_address ?? '-'); ?>

            <?php endif; ?>
        </td>
        <td><?php echo e($server->region ?? '-'); ?></td>
        <td>
            <span id="server-status-<?php echo e($server->id); ?>" class="badge <?php echo e($statusClass); ?>">
                <?php echo e($showStatus); ?>

            </span>
        </td>
        <td>
            <?php if($server->price_hourly_toman): ?>
                <?php echo e(number_format($server->price_hourly_toman)); ?> <span class="text-muted" style="font-size:13px;">تومان</span>
            <?php else: ?>
                <span class="text-muted">-</span>
            <?php endif; ?>
        </td>
        <td><?php echo e($server->created_at?->diffForHumans() ?? '-'); ?></td>
        <td>
            <div class="dropdown dropdown-server <?php echo e($server->status === 'suspended' ? 'server-suspended' : ''); ?>">
                <button class="btn btn-soft-primary btn-sm dropdown-toggle" type="button" 
                    <?php echo e($server->status === 'suspended' ? 'disabled' : ''); ?>>
                    <i class="ri-more-fill align-middle"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end" id="server-actions-<?php echo e($server->id); ?>">
                    <?php if($isActive): ?>
                        <li>
                            <a class="dropdown-item text-primary" href="<?php echo e(route('servers.overview', $server->id)); ?>">
                                <i class="ri-information-line"></i> مدیریت
                            </a>
                        </li>
                        <li>
                            <button onclick="PowerServer('power_off', <?php echo e($server->id); ?>)" class="dropdown-item text-danger">
                                <i class="ri-shut-down-line"></i> خاموش کردن
                            </button>
                        </li>
                    <?php elseif($isOff): ?>
                        <li>
                            <a class="dropdown-item text-primary" href="<?php echo e(route('servers.overview', $server->id)); ?>">
                                <i class="ri-information-line"></i> مدیریت
                            </a>
                        </li>
                        <li>
                            <button onclick="PowerServer('power_on', <?php echo e($server->id); ?>)" class="dropdown-item text-success">
                                <i class="ri-play-line"></i> روشن کردن
                            </button>
                        </li>
                    <?php elseif($isInProgress): ?>
                        <li class="dropdown-item text-muted">در حال آماده‌سازی...</li>
                    <?php endif; ?>

                    <?php if(!$isInProgress && $server->status !== 'suspended'): ?>
                        <li>
                            <button onclick="RebootServer(<?php echo e($server->id); ?>)" class="dropdown-item">
                                <i class="ri-restart-line"></i> ریبوت
                            </button>
                        </li>
                        <li>
                            <button onclick="deleteServer(<?php echo e($server->id); ?>)" class="dropdown-item text-danger">
                                <i class="ri-delete-bin-6-line"></i> حذف
                            </button>
                        </li>
                    <?php endif; ?>
                </ul>
                <?php if($server->status === 'suspended'): ?>
                    <div class="text-danger mt-2 suspended-alert" style="font-size:12px;">مسدود: برای مدیریت و راه‌اندازی سرور، ابتدا کیف پول را شارژ کنید.</div>
                <?php endif; ?>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// مدیریت Dropdown
document.querySelectorAll('.dropdown-server .dropdown-toggle').forEach(btn=>{
    btn.addEventListener('click', e=>{
        e.preventDefault();
        const parent = btn.parentElement;
        if(parent.classList.contains('server-suspended')) return; // سرور ساسپند شده: اجازه باز شدن منو نداریم
        parent.classList.toggle('show');
    });
});

document.addEventListener('click', e=>{
    document.querySelectorAll('.dropdown-server').forEach(drop=>{
        if(!drop.contains(e.target)) drop.classList.remove('show');
    });
});

// حذف سرور
function deleteServer(id){
    Swal.fire({
        title:'حذف سرور؟',
        text:'این عملیات قابل بازگشت نیست!',
        icon:'warning',
        showCancelButton:true,
        confirmButtonText:'بله، حذف کن',
        cancelButtonText:'لغو'
    }).then(result=>{
        if(result.isConfirmed){
            fetch(`/cloud/servers/${id}/delete`, {
                method:'POST',
                headers:{'Content-Type':'application/json','X-CSRF-TOKEN':'<?php echo e(csrf_token()); ?>'},
            })
            .then(res=>res.json())
            .then(data=>{
                if(data.status==='success'){
                    Swal.fire({icon:'success',title:'حذف شد',text:data.message,timer:1500,showConfirmButton:false});
                    document.getElementById('server-'+id)?.remove();
                }else{
                    Swal.fire({icon:'error',title:'خطا!',text:data.message});
                }
            });
        }
    });
}

// ریبوت سرور
function RebootServer(id){
    fetch(`/cloud/servers/${id}/reboot`, {
        method:'POST',
        headers:{'X-CSRF-TOKEN':'<?php echo e(csrf_token()); ?>'}
    }).then(res=>res.json())
    .then(data=>{
        if(data.status==='success'){
            Swal.fire({icon:'success',title:'راه‌اندازی مجدد',text:data.message,timer:1500,showConfirmButton:false});
        }else{
            Swal.fire({icon:'error',title:'خطا!',text:data.message});
        }
    });
}

// پاور سرور با کنترل وضعیت واقعی
function PowerServer(action, id){
    const statusEl = document.getElementById('server-status-' + id);

    // بررسی وضعیت فعلی قبل از ارسال
    if(statusEl && (statusEl.innerText === 'در حال آماده‌سازی' || statusEl.innerText === 'در حال آماده سازی' || statusEl.innerText === 'مسدود (کمبود اعتبار)')){
        Swal.fire({icon:'info',title:'غیرفعال',text:'سرور امکان مدیریت ندارد.'});
        return;
    }

    fetch(`/cloud/servers/${id}/power`, {
        method:'POST',
        headers:{'X-CSRF-TOKEN':'<?php echo e(csrf_token()); ?>','Content-Type':'application/json'},
        body: JSON.stringify({state: action === 'power_on' ? 1 : 0})
    }).then(res=>res.json())
    .then(data=>{
        if(data.status==='success'){
            Swal.fire({icon:'success',title:'تغییر وضعیت',text:data.message,timer:1500,showConfirmButton:false});
        }else{
            Swal.fire({icon:'error',title:'خطا!',text:data.message});
        }
    });
}

// بروزرسانی سرورها و دکمه‌ها
function refreshServers() {
    fetch('<?php echo e(route("cloud.projects.servers.refresh", $project->id)); ?>')
    .then(res=>res.json())
    .then(data=>{
        data.servers.forEach(server=>{
            const ipEl = document.getElementById('server-ip-' + server.id);
            const progressEl = document.getElementById('server-progress-' + server.id);
            const statusEl = document.getElementById('server-status-' + server.id);
            const actionsEl = document.getElementById('server-actions-' + server.id);
            const rowEl = document.getElementById('server-' + server.id);

            // بروزرسانی IP و پروگرس
            if(server.status === 'pending' || server.status === 'creating'){
                if(progressEl){
                    progressEl.style.width = (server.progress ?? 0) + '%';
                    progressEl.innerText = `در حال آماده سازی (${server.progress ?? 0}%)`;
                    progressEl.style.display = 'block';
                }
                if(statusEl){
                    statusEl.innerText = (server.status === 'creating') ? 'در حال آماده‌سازی' : 'در حال آماده سازی';
                    statusEl.className = 'badge border border-warning text-warning';
                }
            } else if(server.status === 'suspended'){
                if(ipEl) ipEl.innerText = server.ip_address ?? '-';
                if(progressEl) progressEl.style.display = 'none';
                if(statusEl){
                    statusEl.innerText = 'مسدود (کمبود اعتبار)';
                    statusEl.className = 'badge border border-danger text-danger';
                }
                if(rowEl) rowEl.classList.add('server-suspended');
                if(actionsEl) actionsEl.closest('.dropdown-server').classList.add('server-suspended');
                // اضافه یا بروزرسانی پیام هشدار
                let alertMsg = actionsEl.closest('.dropdown-server').querySelector('.suspended-alert');
                if(!alertMsg){
                    alertMsg = document.createElement('div');
                    alertMsg.className = 'text-danger mt-2 suspended-alert';
                    alertMsg.style.fontSize = '12px';
                    alertMsg.innerText = 'مسدود: برای مدیریت و راه‌اندازی سرور، ابتدا کیف پول را شارژ کنید.';
                    actionsEl.closest('.dropdown-server').appendChild(alertMsg);
                }
            } else {
                if(ipEl) ipEl.innerText = server.ip_address ?? '-';
                if(progressEl) progressEl.style.display = 'none';
                // نگاشت وضعیت‌ها در JS
                if(statusEl){
                    if(['active','running','on'].includes(server.status)){
                        statusEl.innerText = 'روشن';
                        statusEl.className = 'badge border border-success text-success';
                    } else if(['off','stopped','shutoff'].includes(server.status)){
                        statusEl.innerText = 'خاموش';
                        statusEl.className = 'badge border border-secondary text-secondary';
                    } else if(['creating','pending','starting','initializing','installing'].includes(server.status)){
                        statusEl.innerText = 'در حال آماده سازی';
                        statusEl.className = 'badge border border-warning text-warning';
                    } else if(server.status === 'suspended'){
                        statusEl.innerText = 'مسدود (کمبود اعتبار)';
                        statusEl.className = 'badge border border-danger text-danger';
                    } else {
                        statusEl.innerText = 'نامشخص';
                        statusEl.className = 'badge border border-secondary text-secondary';
                    }
                }
                if(rowEl) rowEl.classList.remove('server-suspended');
                if(actionsEl) actionsEl.closest('.dropdown-server').classList.remove('server-suspended');
                // حذف پیام هشدار اگر وجود داشت
                let alertMsg = actionsEl.closest('.dropdown-server').querySelector('.suspended-alert');
                if(alertMsg) alertMsg.remove();
            }

            // بروزرسانی دکمه‌ها
            if(actionsEl){
                let html = '';
                if(['active','running','on'].includes(server.status)){
                    html += `<li><a class="dropdown-item text-primary" href="/cloud/servers/${server.id}/overview"><i class="ri-information-line"></i> مدیریت</a></li>`;
                    html += `<li><button onclick="PowerServer('power_off', ${server.id})" class="dropdown-item text-danger"><i class="ri-shut-down-line"></i> خاموش کردن</button></li>`;
                } else if(['off','stopped','shutoff'].includes(server.status)){
                    html += `<li><a class="dropdown-item text-primary" href="/cloud/servers/${server.id}/overview"><i class="ri-information-line"></i> مدیریت</a></li>`;
                    html += `<li><button onclick="PowerServer('power_on', ${server.id})" class="dropdown-item text-success"><i class="ri-play-line"></i> روشن کردن</button></li>`;
                } else if(['creating','pending','starting','initializing','installing'].includes(server.status)){
                    html += `<li class="dropdown-item text-muted">در حال آماده‌سازی...</li>`;
                }

                if(!['creating','pending','starting','initializing','installing','suspended'].includes(server.status)){
                    html += `<li><button onclick="RebootServer(${server.id})" class="dropdown-item"><i class="ri-restart-line"></i> ریبوت</button></li>`;
                    html += `<li><button onclick="deleteServer(${server.id})" class="dropdown-item text-danger"><i class="ri-delete-bin-6-line"></i> حذف</button></li>`;
                }
                actionsEl.innerHTML = html;
            }
        });
    }).catch(err=>console.error('Error fetching servers:', err));
}

// Polling هر 5 ثانیه
setInterval(refreshServers, 5000);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.simple.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/projects/servers.blade.php ENDPATH**/ ?>