<div class="modal fade" id="assignIpModal" tabindex="-1" dir="rtl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="ri-link me-2"></i>
                    Assign to Server
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="assignIpForm">
                <input type="hidden" id="assignIpId">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">IP Address:</label>
                        <input type="text" class="form-control" id="assignIpAddress" readonly>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Location:</label>
                        <input type="text" class="form-control" id="assignIpLocation" readonly>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">انتخاب سرور <span class="text-danger">*</span></label>
                        <select class="form-select" name="server_id" id="assignServerSelect" required>
                            <option value="">-- انتخاب کنید --</option>
                            <?php $__currentLoopData = $servers->where('status', '!=', 'deleted'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($server->id); ?>" 
                                        data-location="<?php echo e($server->location); ?>"
                                        data-status="<?php echo e($server->status); ?>"
                                        <?php if(!in_array($server->status, ['stopped', 'off'])): ?> disabled <?php endif; ?>>
                                    <?php echo e($server->name); ?> 
                                    (<?php echo e($server->location); ?>)
                                    <?php if(!in_array($server->status, ['stopped', 'off'])): ?>
                                        - ⚠️ باید خاموش باشد
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <small class="text-muted">فقط سرورهای خاموش در همان Location</small>
                    </div>

                    <div class="alert alert-warning">
                        <i class="ri-alert-line me-2"></i>
                        <strong>توجه:</strong>
                        <ul class="mb-0 mt-2">
                            <li>سرور باید خاموش باشد</li>
                            <li>سرور باید در همان Location باشد</li>
                            <li>هزینه ساعتی IP همچنان کسر می‌شود</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-success">
                        <i class="ri-link me-1"></i>
                        Assign to Server
                    </button>
                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/projects/servers/primaryips/modals/assign.blade.php ENDPATH**/ ?>