

<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
<style>
    :root {
        --purple-primary: #7c3aed;
        --purple-secondary: #a78bfa;
        --purple-light: #ede9fe;
        --purple-dark: #5b21b6;
        --gradient-purple: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --gradient-purple-light: linear-gradient(135deg, #a78bfa 0%, #7c3aed 100%);
    }

    /* Stats Cards */
    .card-stat {
        background: white;
        border-radius: 16px;
        border: none;
        overflow: hidden;
        position: relative;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 8px rgba(124, 58, 237, 0.08);
    }

    .card-stat::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        background: var(--gradient-purple);
        transform: scaleX(0);
        transition: transform 0.4s ease;
    }

    .card-stat:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 24px rgba(124, 58, 237, 0.15) !important;
    }

    .card-stat:hover::before {
        transform: scaleX(1);
    }

    .card-stat .card-body {
        padding: 1.25rem;
    }

    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        background: var(--gradient-purple);
        color: white;
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.3);
    }

    .stat-label {
        font-size: 0.75rem;
        color: #6b7280;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 0.25rem;
    }

    .stat-value {
        font-size: 1.75rem;
        font-weight: 700;
        background: var(--gradient-purple);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        line-height: 1.2;
    }

    /* Breadcrumb */
    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
    }

    .breadcrumb-item a {
        color: var(--purple-primary);
        text-decoration: none;
        transition: all 0.3s;
    }

    .breadcrumb-item a:hover {
        color: var(--purple-dark);
    }

    .breadcrumb-item.active {
        color: #6b7280;
    }

    .page-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.25rem;
    }

    .page-title i {
        color: var(--purple-primary);
    }

    .page-subtitle {
        font-size: 0.875rem;
        color: #6b7280;
        margin: 0;
    }

    /* Buttons */
    .btn-purple {
        background: var(--gradient-purple);
        border: none;
        color: white;
        padding: 0.5rem 1.25rem;
        border-radius: 10px;
        font-weight: 600;
        font-size: 0.875rem;
        transition: all 0.3s;
        box-shadow: 0 2px 8px rgba(124, 58, 237, 0.25);
    }

    .btn-purple:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.35);
        color: white;
    }

    .btn-outline-purple {
        border: 1.5px solid var(--purple-primary);
        color: var(--purple-primary);
        background: white;
        padding: 0.5rem 1.25rem;
        border-radius: 10px;
        font-weight: 600;
        font-size: 0.875rem;
        transition: all 0.3s;
    }

    .btn-outline-purple:hover {
        background: var(--gradient-purple);
        color: white;
        border-color: transparent;
        transform: translateY(-2px);
    }

    /* Table */
    .table-card {
        background: white;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(124, 58, 237, 0.08);
        border: 1px solid rgba(124, 58, 237, 0.1);
    }

    .table {
        margin-bottom: 0;
    }

    .table thead {
        background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%);
    }

    .table thead th {
        border: none;
        padding: 1rem 0.75rem;
        font-weight: 700;
        color: var(--purple-dark);
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        border-bottom: 1px solid rgba(124, 58, 237, 0.06);
        transition: all 0.3s;
    }

    .table tbody tr:hover {
        background: linear-gradient(135deg, #faf5ff 0%, #f5f3ff 100%);
    }

    .table tbody td {
        padding: 1rem 0.75rem;
        vertical-align: middle;
        font-size: 0.875rem;
    }

    /* Badges */
    .badge-modern {
        padding: 0.35rem 0.75rem;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.7rem;
        letter-spacing: 0.3px;
    }

    .badge-purple {
        background: linear-gradient(135deg, #a78bfa 0%, #7c3aed 100%);
        color: white;
    }

    .badge-info {
        background: linear-gradient(135deg, #60a5fa 0%, #3b82f6 100%);
        color: white;
    }

    .badge-success {
        background: linear-gradient(135deg, #34d399 0%, #10b981 100%);
        color: white;
    }

    .badge-warning {
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        color: white;
    }

    /* IP Display */
    .ip-display {
        background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%);
        padding: 0.75rem;
        border-radius: 10px;
        border: 1px solid rgba(124, 58, 237, 0.15);
    }

    .ip-name {
        font-weight: 700;
        color: var(--purple-dark);
        font-size: 0.875rem;
    }

    .ip-code {
        background: white;
        padding: 0.25rem 0.5rem;
        border-radius: 6px;
        font-family: 'Courier New', monospace;
        color: var(--purple-primary);
        font-size: 0.75rem;
        border: 1px solid rgba(124, 58, 237, 0.2);
    }

    /* Dropdown */
    .dropdown-menu {
        border-radius: 12px;
        border: 1px solid rgba(124, 58, 237, 0.1);
        box-shadow: 0 8px 24px rgba(124, 58, 237, 0.12);
        padding: 0.5rem;
    }

    .dropdown-item {
        border-radius: 8px;
        padding: 0.5rem 0.75rem;
        transition: all 0.3s;
        margin: 0.125rem 0;
        font-size: 0.875rem;
    }

    .dropdown-item:hover {
        background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%);
        color: var(--purple-dark);
        transform: translateX(3px);
    }

    .dropdown-item.text-danger:hover {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #dc2626;
    }

    /* Action Button */
    .btn-action {
        width: 36px;
        height: 36px;
        border-radius: 10px;
        border: none;
        background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%);
        color: var(--purple-primary);
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s;
        padding: 0;
    }

    .btn-action:hover {
        background: var(--gradient-purple);
        color: white;
        transform: rotate(90deg);
    }

    /* Server Link */
    .server-link {
        display: inline-flex;
        align-items: center;
        padding: 0.4rem 0.75rem;
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        border-radius: 8px;
        color: #dc2626;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.8rem;
        transition: all 0.3s;
    }

    .server-link:hover {
        background: linear-gradient(135deg, #fecaca 0%, #fca5a5 100%);
        color: #991b1b;
        transform: translateX(3px);
    }

    /* Cost Display */
    .cost-display {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        padding: 0.5rem 0.75rem;
        border-radius: 8px;
        display: inline-block;
    }

    .cost-value {
        font-size: 1rem;
        font-weight: 700;
        color: #dc2626;
        line-height: 1.2;
    }

    .cost-label {
        font-size: 0.7rem;
        color: #991b1b;
    }

    /* Empty State */
    .empty-state {
        padding: 4rem 1rem;
        text-align: center;
    }

    .empty-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 1.5rem;
        background: var(--gradient-purple);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 40px;
        color: white;
        animation: float 3s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-15px); }
    }

    /* Checkbox */
    .form-check-input:checked {
        background-color: var(--purple-primary);
        border-color: var(--purple-primary);
    }

    .form-check-input:focus {
        border-color: var(--purple-secondary);
        box-shadow: 0 0 0 0.2rem rgba(124, 58, 237, 0.25);
    }

    /* Location Badge */
    .location-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.4rem;
        padding: 0.4rem 0.75rem;
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
        border-radius: 8px;
        font-weight: 600;
        color: #1e40af;
        font-size: 0.8rem;
    }

    /* Animation */
    @keyframes slideIn {
        from {
            opacity: 0;
            transform: translateY(15px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .card-stat {
        animation: slideIn 0.5s ease-out forwards;
    }

    .card-stat:nth-child(1) { animation-delay: 0.1s; }
    .card-stat:nth-child(2) { animation-delay: 0.2s; }
    .card-stat:nth-child(3) { animation-delay: 0.3s; }
    .card-stat:nth-child(4) { animation-delay: 0.4s; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="container" data-project-id="<?php echo e($project->id); ?>">
            
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="/cloud/projects">پروژه‌ها</a></li>
                            <li class="breadcrumb-item"><a href="/cloud/projects/<?php echo e($project->id); ?>/servers"><?php echo e($project->name); ?></a></li>
                            <li class="breadcrumb-item active">Primary IPs</li>
                        </ol>
                    </nav>
                    <h3 class="page-title mb-0">
                        <i class="ri-ip-line me-2"></i>
                        مدیریت Primary IPs
                    </h3>
                    <p class="page-subtitle">مدیریت آدرس‌های IP اصلی سرورهای Hetzner</p>
                </div>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-purple" id="btnFilter">
                        <i class="ri-filter-3-line me-1"></i>
                        فیلتر
                    </button>
                    <button class="btn btn-purple" id="btnCreatePrimaryIp">
                        <i class="ri-add-circle-line me-1"></i>
                        Create Primary IP
                    </button>
                </div>
            </div>

            
            <div class="row g-3 mb-4">
                <div class="col-md-3">
                    <div class="card-stat">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <div class="stat-label">مجموع IPs</div>
                                    <div class="stat-value"><?php echo e($stats['total']); ?></div>
                                </div>
                                <div class="stat-icon">
                                    <i class="ri-ip-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card-stat">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <div class="stat-label">Assigned</div>
                                    <div class="stat-value"><?php echo e($stats['assigned']); ?></div>
                                </div>
                                <div class="stat-icon">
                                    <i class="ri-links-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card-stat">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <div class="stat-label">Unassigned</div>
                                    <div class="stat-value"><?php echo e($stats['unassigned']); ?></div>
                                </div>
                                <div class="stat-icon">
                                    <i class="ri-link-unlink-m"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card-stat">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <div class="stat-label">هزینه ساعتی کل</div>
                                    <div class="stat-value"><?php echo e(number_format($stats['total_hourly_cost'])); ?></div>
                                    <small class="text-muted" style="font-size: 0.7rem;">تومان/ساعت</small>
                                </div>
                                <div class="stat-icon">
                                    <i class="ri-money-dollar-circle-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="table-card">
                <div class="table-responsive">
                    <table class="table align-middle" id="primaryIpsTable">
                        <thead>
                            <tr>
                                <th style="width: 5%">
                                    <input type="checkbox" class="form-check-input" id="selectAll">
                                </th>
                                <th style="width: 20%">Name / IP Address</th>
                                <th style="width: 15%">Server</th>
                                <th style="width: 20%">Reverse DNS</th>
                                <th style="width: 12%">Location</th>
                                <th style="width: 13%">هزینه ساعتی</th>
                                <th style="width: 10%">ایجاد شده</th>
                                <th style="width: 5%"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $primaryIps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-ip-id="<?php echo e($ip->id); ?>" 
                                data-type="<?php echo e($ip->type); ?>" 
                                data-status="<?php echo e($ip->status); ?>" 
                                data-location="<?php echo e($ip->location); ?>">
                                <td>
                                    <input type="checkbox" class="form-check-input row-select">
                                </td>
                                <td>
                                    <div class="ip-display">
                                        <div class="d-flex align-items-center gap-2 mb-1">
                                            <?php if($ip->type === 'ipv4'): ?>
                                                <span class="badge-modern badge-purple">IPv4</span>
                                            <?php else: ?>
                                                <span class="badge-modern badge-info">IPv6</span>
                                            <?php endif; ?>
                                            <span class="ip-name"><?php echo e($ip->provider_ip_id ? "primary-ip-{$ip->provider_ip_id}" : $ip->ip); ?></span>
                                        </div>
                                        <code class="ip-code"><?php echo e($ip->ip); ?></code>
                                    </div>
                                </td>
                                <td>
                                    <?php if($ip->server): ?>
                                        <a href="/cloud/servers/<?php echo e($ip->server->id); ?>/overview" class="server-link">
                                            <i class="ri-server-line me-1"></i>
                                            <?php echo e($ip->server->name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="badge-modern badge-warning">Unassigned</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e($ip->rdns ?? '-'); ?></small>
                                </td>
                                <td>
                                    <span class="location-badge">
                                        🇩🇪 <?php echo e($ip->location ?? 'Nuremberg'); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="cost-display">
                                        <div class="cost-value"><?php echo e(number_format($ip->hourly_cost)); ?></div>
                                        <div class="cost-label">تومان/ساعت</div>
                                    </div>
                                    <?php if($ip->status === 'detached' && $ip->detached_at): ?>
                                        <div class="mt-2">
                                            <span class="badge-modern badge-warning">
                                                <i class="ri-time-line me-1"></i>
                                                <?php echo e($ip->getHoursSinceDetach()); ?> ساعت
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e($ip->created_at->format('Y/m/d')); ?></small>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn-action" data-bs-toggle="dropdown">
                                            <i class="ri-more-2-fill"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <?php if($ip->status === 'detached'): ?>
                                                <li>
                                                    <a class="dropdown-item btn-assign-ip" href="#" 
                                                       data-ip-id="<?php echo e($ip->id); ?>" 
                                                       data-ip-address="<?php echo e($ip->ip); ?>"
                                                       data-location="<?php echo e($ip->location); ?>">
                                                        <i class="ri-link me-2"></i>
                                                        Assign to Server
                                                    </a>
                                                </li>
                                            <?php else: ?>
                                                <li>
                                                    <a class="dropdown-item btn-unassign-ip" href="#" 
                                                       data-ip-id="<?php echo e($ip->id); ?>" 
                                                       data-ip-address="<?php echo e($ip->ip); ?>">
                                                        <i class="ri-link-unlink me-2"></i>
                                                        Unassign from Server
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <li>
                                                <a class="dropdown-item btn-edit-rdns" href="#" 
                                                   data-ip-id="<?php echo e($ip->id); ?>" 
                                                   data-ip-address="<?php echo e($ip->ip); ?>"
                                                   data-rdns="<?php echo e($ip->rdns); ?>">
                                                    <i class="ri-edit-line me-2"></i>
                                                    Edit Reverse DNS
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item text-danger btn-delete-ip" href="#" 
                                                   data-ip-id="<?php echo e($ip->id); ?>" 
                                                   data-ip-address="<?php echo e($ip->ip); ?>"
                                                   data-cost="<?php echo e($ip->status === 'detached' ? number_format($ip->calculateDetachedCost()) : 0); ?>">
                                                    <i class="ri-delete-bin-line me-2"></i>
                                                    Delete
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8">
                                    <div class="empty-state">
                                        <div class="empty-icon">
                                            <i class="ri-inbox-line"></i>
                                        </div>
                                        <h5 style="color: var(--purple-dark); margin-bottom: 0.75rem;">هنوز Primary IP ای ندارید</h5>
                                        <p class="text-muted mb-3" style="font-size: 0.875rem;">اولین آدرس IP خود را ایجاد کنید</p>
                                        <button class="btn btn-purple" onclick="document.getElementById('btnCreatePrimaryIp').click()">
                                            <i class="ri-add-circle-line me-1"></i>
                                            ایجاد اولین IP
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            </div>
        </div>
    </div>
</div>


<?php echo $__env->make('projects.servers.primaryips.modals.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('projects.servers.primaryips.modals.assign', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('projects.servers.primaryips.modals.unassign', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('projects.servers.primaryips.modals.rdns', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('projects.servers.primaryips.modals.delete', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo e(asset('assets/js/primary-ips.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.simple.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/projects/servers/primaryips/index.blade.php ENDPATH**/ ?>