    <div class="p-4">
        <h5 class="mb-3">اطلاعات شبکه</h5>
        <div class="row">
            <div class="col-12 mt-3">
                <div class="card bg-light overflow-hidden w-100">
                    <div class="card-body">
                        <div class="d-flex flex-row-reverse">
                            <div class="flex-grow-1 text-end">
                                <h6 class="mb-0 fs-5">Bandwidth Usage</h6>
                            </div>
                            <div class="flex-shrink-0 text-end">
                                <h6 class="mb-0 fs-4"><?php echo e($used_tb); ?>/<?php echo e($limit_tb); ?> TB</h6>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 mb-2 px-4">
                        <div class="progress animated-progress custom-progress progress-label">
                            <div class="progress-bar
                                <?php if($percent > 90): ?>
                                    bg-danger
                                <?php elseif($percent > 75): ?>
                                    bg-warning
                                <?php else: ?>
                                    bg-primary
                                <?php endif; ?>"
                                role="progressbar"
                                style="width: <?php echo e($percent); ?>%;"
                                aria-valuenow="<?php echo e($percent); ?>" aria-valuemin="0" aria-valuemax="100">
                                <div class="label"><?php echo e($percent); ?>%</div>
                            </div>
                        </div>
                    </div>

                    <!-- هشدار هزینه اضافه ترافیک (آبی با متن تیره و راست‌چین تمام عرض) -->
                    <div class="alert mt-3 w-100 text-end" role="alert"
                        style="direction: rtl; background-color:#d6eaff; color:#214162; border-color: #7eb6e0;">
                        <strong>در صورت مصرف بیش از سقف پلن و فعال بودن اضافه ترافیک، هر ۱ ترابایت اضافه، مبلغ ۳۵۰,۰۰۰ تومان محاسبه می‌شود.</strong><br>
                        <strong>سقف پهنای باند هر ماه در ابتدای ماه میلادی ریست می‌شود.</strong>
                    </div>

                    <!-- هشدار و دکمه فعال‌سازی اضافه ترافیک (بک گراند قهوه‌ای) -->
                    <div class="alert mt-2 w-100 text-end" role="alert"
                        style="direction: rtl; background-color:#e9cfc2; border-color: #bc9875;">
                        <div class="d-flex flex-row-reverse align-items-center w-100" style="gap: 1rem;">
                            <div class="flex-shrink-0 ms-3">
                                <i class='ri-time-line fs-16 align-middle'></i>
                            </div>
                            <div class="flex-grow-1 text-end">
                                <h5 class="alert-heading mb-1 mt-0">پهنای باند!</h5>
                                <p class="mb-2 mt-0" style="font-size: 1rem;">
                                    هر سرور سقف پهنای باند مخصوص به خود را دارد و برخی سرورها دارای سقف نامحدود هستند.
                                </p>
                                <p class="mb-0 mt-0" style="font-size: 1rem;">
                                    برخی سرورها از اضافه ترافیک پشتیبانی می‌کنند که به ازای هر ۱ ترابایت، هزینه جداگانه محاسبه خواهد شد.
                                </p>
                            </div>
                            <div class="flex-shrink-0 me-2">
                                <button onclick="OverBandwidth()" class="btn btn-dark">
                                    <i class="ri-add-line align-bottom"></i> فعال‌سازی اضافه ترافیک
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- مدال اضافه ترافیک -->
                    <div class="modal fade" id="overBandwidthModal" tabindex="-1" aria-labelledby="overBandwidthModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content text-end" style="direction: rtl;">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="overBandwidthModalLabel">فعال‌سازی اضافه ترافیک</h5>
                                    <button type="button" class="btn-close ms-0" data-bs-dismiss="modal" aria-label="بستن"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="alert alert-warning text-center mb-2" style="direction: rtl;">
                                        این امکان در دست توسعه است.<br>
                                        با آپدیت بعدی اضافه خواهد شد.
                                    </div>
                                </div>
                                <div class="modal-footer justify-content-end">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">بستن</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <script>
                    function OverBandwidth() {
                        let modal = new bootstrap.Modal(document.getElementById('overBandwidthModal'));
                        modal.show();
                    }
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/cloud/public_html/laravel-project/resources/views/servers/partials/bandwidth-tab.blade.php ENDPATH**/ ?>