<div class="p-4">
    <h5 class="mb-3">هزینه‌های سرور</h5>
    
    <!-- کارت آمار کلی -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <div class="row g-3">
                        <!-- مجموع هزینه‌ها -->
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 me-3">
                                    <div class="avatar-sm">
                                        <div class="avatar-title bg-primary-subtle text-primary rounded fs-3">
                                            <i class="ri-money-dollar-circle-line"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-grow-1 text-end">
                                    <p class="text-muted mb-1">مجموع هزینه‌ها</p>
                                    <h4 class="mb-0" id="totalCost">0 تومان</h4>
                                </div>
                            </div>
                        </div>

                        <!-- هزینه سرور -->
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 me-3">
                                    <div class="avatar-sm">
                                        <div class="avatar-title bg-success-subtle text-success rounded fs-3">
                                            <i class="ri-server-line"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-grow-1 text-end">
                                    <p class="text-muted mb-1">هزینه سرور</p>
                                    <h4 class="mb-0" id="serverCost">0 تومان</h4>
                                </div>
                            </div>
                        </div>

                        <!-- هزینه IP -->
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 me-3">
                                    <div class="avatar-sm">
                                        <div class="avatar-title bg-info-subtle text-info rounded fs-3">
                                            <i class="ri-global-line"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-grow-1 text-end">
                                    <p class="text-muted mb-1">هزینه IP</p>
                                    <h4 class="mb-0" id="ipCost">0 تومان</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- فیلترها -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label class="form-label">از تاریخ</label>
                            <input type="date" class="form-control" id="fromDate" value="<?php echo e(now()->startOfMonth()->format('Y-m-d')); ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">تا تاریخ</label>
                            <input type="date" class="form-control" id="toDate" value="<?php echo e(now()->format('Y-m-d')); ?>">
                        </div>
                        <div class="col-md-4">
                            <button type="button" class="btn btn-primary w-100" onclick="loadCosts()">
                                <i class="ri-search-line align-bottom"></i> جستجو
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- اطلاعیه -->
    <div class="alert alert-info text-end mb-4" role="alert" style="direction: rtl; background-color:#d6eaff; color:#214162; border-color: #7eb6e0;">
        <div class="d-flex flex-row-reverse align-items-center">
            <div class="flex-shrink-0 ms-3">
                <i class='ri-information-line fs-20'></i>
            </div>
            <div class="flex-grow-1">
                <strong>هزینه‌های این سرور به صورت ساعتی محاسبه می‌شود.</strong><br>
                شامل هزینه سرور، IP های اضافی، و سایر خدمات مرتبط با این سرور.
            </div>
        </div>
    </div>

    <!-- لیست تراکنش‌ها -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="ri-file-list-3-line align-middle me-1"></i>
                        ریز تراکنش‌ها
                        <span class="badge bg-primary ms-2" id="transactionCount">0</span>
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Loading -->
                    <div id="loadingSpinner" class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">در حال بارگذاری...</span>
                        </div>
                        <p class="mt-2 text-muted">در حال بارگذاری اطلاعات...</p>
                    </div>

                    <!-- جدول تراکنش‌ها -->
                    <div id="transactionsTable" style="display: none;">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr class="text-end">
                                        <th>نوع</th>
                                        <th>توضیحات</th>
                                        <th>مبلغ</th>
                                        <th>تاریخ</th>
                                    </tr>
                                </thead>
                                <tbody id="transactionsBody">
                                    <!-- محتوا با AJAX لود می‌شود -->
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div id="paginationInfo" class="text-muted"></div>
                            <nav>
                                <ul class="pagination mb-0" id="pagination"></ul>
                            </nav>
                        </div>
                    </div>

                    <!-- پیام خالی -->
                    <div id="emptyState" class="text-center py-5" style="display: none;">
                        <i class="ri-file-list-line" style="font-size: 4rem; color: #ccc;"></i>
                        <h5 class="mt-3 text-muted">تراکنشی یافت نشد</h5>
                        <p class="text-muted">در بازه زمانی انتخابی، هیچ تراکنشی برای این سرور ثبت نشده است.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let currentPage = 1;
const serverId = <?php echo e($server->id); ?>;

// بارگذاری اولیه - بلافاصله اجرا می‌شه
(function() {
    // اگر صفحه قبلاً لود شده، فوراً اجرا کن
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', loadCosts);
    } else {
        // صفحه قبلاً لود شده، الان اجرا کن
        setTimeout(loadCosts, 100);
    }
})();

// بارگذاری هزینه‌ها
function loadCosts(page = 1) {
    currentPage = page;
    
    const fromDate = document.getElementById('fromDate').value;
    const toDate = document.getElementById('toDate').value;
    
    console.log('🚀 loadCosts called!', {serverId, fromDate, toDate, page});
    
    // نمایش Loading
    document.getElementById('loadingSpinner').style.display = 'block';
    document.getElementById('transactionsTable').style.display = 'none';
    document.getElementById('emptyState').style.display = 'none';
    
    // درخواست AJAX - مسیر مشابه بقیه تب‌ها
    const url = `/cloud/servers/${serverId}/costs-data?from=${fromDate}&to=${toDate}&page=${page}`;
    console.log('📡 Fetching URL:', url);
    
    fetch(url)
        .then(response => {
            console.log('✅ Response received:', response.status, response.ok);
            if (!response.ok) {
                throw new Error('خطا در دریافت اطلاعات - Status: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            console.log('📦 Data received:', data);
            // مخفی کردن Loading
            document.getElementById('loadingSpinner').style.display = 'none';
            
            if (data.success) {
                // بروزرسانی آمار
                updateStats(data.stats);
                
                // نمایش تراکنش‌ها
                if (data.transactions.length > 0) {
                    displayTransactions(data.transactions);
                    displayPagination(data.pagination);
                    document.getElementById('transactionsTable').style.display = 'block';
                } else {
                    document.getElementById('emptyState').style.display = 'block';
                }
            }
        })
        .catch(error => {
            console.error('Error details:', error); // دیباگ بیشتر
            document.getElementById('loadingSpinner').style.display = 'none';
            document.getElementById('emptyState').style.display = 'block';
            document.getElementById('emptyState').innerHTML = `
                <div class="text-center py-5">
                    <i class="ri-error-warning-line" style="font-size: 4rem; color: #dc3545;"></i>
                    <h5 class="mt-3 text-danger">خطا در دریافت اطلاعات</h5>
                    <p class="text-muted">${error.message}</p>
                    <button class="btn btn-primary" onclick="loadCosts()">تلاش مجدد</button>
                </div>
            `;
        });
}

// بروزرسانی آمار
function updateStats(stats) {
    document.getElementById('totalCost').textContent = stats.total_cost_formatted;
    document.getElementById('serverCost').textContent = stats.server_costs_formatted;
    document.getElementById('ipCost').textContent = stats.ip_costs_formatted;
    document.getElementById('transactionCount').textContent = stats.transaction_count;
}

// نمایش تراکنش‌ها
function displayTransactions(transactions) {
    const tbody = document.getElementById('transactionsBody');
    tbody.innerHTML = '';
    
    transactions.forEach(tx => {
        const row = `
            <tr class="text-end">
                <td>
                    <i class="${tx.type_icon} align-middle me-1"></i>
                    <span class="badge bg-${getTypeBadgeColor(tx.type)}">${tx.type_label}</span>
                </td>
                <td>${tx.description}</td>
                <td>
                    <span class="text-danger fw-bold">${tx.amount_formatted}</span>
                </td>
                <td>
                    <small class="text-muted">${tx.created_at}</small>
                    <br>
                    <small class="text-muted">${tx.created_at_human}</small>
                </td>
            </tr>
        `;
        tbody.innerHTML += row;
    });
}

// نمایش Pagination
function displayPagination(pagination) {
    const paginationInfo = document.getElementById('paginationInfo');
    paginationInfo.textContent = `نمایش ${pagination.from || 0} تا ${pagination.to || 0} از ${pagination.total} مورد`;
    
    const paginationUl = document.getElementById('pagination');
    paginationUl.innerHTML = '';
    
    // دکمه قبلی
    if (pagination.current_page > 1) {
        paginationUl.innerHTML += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadCosts(${pagination.current_page - 1}); return false;">قبلی</a>
            </li>
        `;
    }
    
    // شماره صفحات
    for (let i = 1; i <= pagination.last_page; i++) {
        const active = i === pagination.current_page ? 'active' : '';
        paginationUl.innerHTML += `
            <li class="page-item ${active}">
                <a class="page-link" href="#" onclick="loadCosts(${i}); return false;">${i}</a>
            </li>
        `;
    }
    
    // دکمه بعدی
    if (pagination.current_page < pagination.last_page) {
        paginationUl.innerHTML += `
            <li class="page-item">
                <a class="page-link" href="#" onclick="loadCosts(${pagination.current_page + 1}); return false;">بعدی</a>
            </li>
        `;
    }
}

// رنگ badge بر اساس نوع
function getTypeBadgeColor(type) {
    const colors = {
        'server_hourly': 'primary',
        'ip_hourly': 'info',
        'penalty': 'danger',
        'server_create': 'success',
        'ip_create': 'warning'
    };
    return colors[type] || 'secondary';
}
</script>

<style>
.avatar-sm {
    height: 3rem;
    width: 3rem;
}

.avatar-title {
    align-items: center;
    display: flex;
    height: 100%;
    justify-content: center;
    width: 100%;
}

.pagination .page-link {
    padding: 0.375rem 0.75rem;
}

.table > :not(caption) > * > * {
    padding: 0.75rem 0.75rem;
}
</style><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/servers/partials/costs-tab.blade.php ENDPATH**/ ?>