          <?php
            // Match plan info for all providers
            $planInfo = null;
            $archLabel = '';
            $catLabel = '';
            if(isset($plans) && is_array($plans) && $server->plan) {
              foreach($plans as $plan) {
                if(
                  (isset($plan['id']) && $plan['id'] == $server->plan) ||
                  (isset($plan['slug']) && $plan['slug'] == $server->plan) ||
                  (isset($plan['name']) && $plan['name'] == $server->plan)
                ) {
                  $planInfo = $plan;
                  // Hetzner: set arch/cat label
                  if(($server->provider ?? '') === 'hetzner') {
                    $archLabel = isset($plan['architecture']) && $plan['architecture'] == 'arm' ? 'ARM' : 'x64';
                    $catLabel = isset($plan['category']) && $plan['category'] == 'cost_optimized' ? 'Cost Optimized' : '';
                  }
                  break;
                }
              }
            }
            // Match OS name
            $osName = $server->image;
            if(isset($osList) && is_array($osList) && $server->image) {
              foreach($osList as $os) {
                if(($os['id'] ?? null) == $server->image) {
                  $osName = $os['name'] ?? $server->image;
                  break;
                }
              }
            }
            // Hetzner override from apiData
            if(($server->provider ?? '') === 'hetzner' && isset($apiData) && isset($apiData->image->description)) {
              $osName = $apiData->image->description;
            }
          ?>
<div class="row">
  <div class="col-lg-3">
    <div class="p-3 border border-dashed">
      <h5>پردازنده (CPU)</h5>
      <p>
        <span id="server-cpu">
          <?php
            $cpu = '-';
            if(($server->provider ?? '') === 'arvan' && !empty($server->vcpu))
              $cpu = $server->vcpu;
            elseif(($server->provider ?? '') === 'hetzner' && isset($planInfo['cores']))
              $cpu = $planInfo['cores'];
            else
              $cpu = $planInfo['vcpu_count'] ?? $planInfo['cpu'] ?? $planInfo['cpu_count'] ?? '-';
          ?>
          <?php echo e($cpu); ?>

        </span>
        <?php if(!empty($archLabel)): ?>
          <span class="badge bg-secondary ms-1"><?php echo e($archLabel); ?></span>
        <?php endif; ?>
        <?php if(!empty($catLabel)): ?>
          <span class="badge bg-warning ms-1"><?php echo e($catLabel); ?></span>
        <?php endif; ?>
      </p>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="p-3 border border-dashed">
      <h5>رم (RAM)</h5>
      <p>
        <span id="server-ram">
          <?php
            $ram = '-';
            if(($server->provider ?? '') === 'arvan' && !empty($server->ram))
              $ram = $server->ram;
            elseif(($server->provider ?? '') === 'hetzner' && isset($planInfo['memory']))
              $ram = $planInfo['memory'];
            else
              $ram = $planInfo['ram'] ?? $planInfo['memory'] ?? '-';
          ?>
          <?php echo e($ram); ?>

        </span>
        <span>
          <?php if(($server->provider ?? '') === 'hetzner' && ($ram !== '-')): ?>  <?php else: ?>  <?php endif; ?>
        </span>
      </p>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="p-3 border border-dashed">
      <h5>دیسک</h5>
    <p>
      <span id="server-disk">
        <?php
          $disk = '-';
          if(($server->provider ?? '') === 'arvan' && !empty($server->disk))
            $disk = $server->disk;
          elseif(($server->provider ?? '') === 'hetzner' && isset($planInfo['disk']))
            $disk = $planInfo['disk'];
          else
            $disk = $planInfo['disk'] ?? '-';
        ?>
        <?php echo e($disk); ?>

      </span>
      
    </p>
  </div>
  </div>
  <div class="col-lg-3">
    <div class="p-3 border border-dashed">
      <h5>سیستم عامل</h5>
      <p>
        <span id="server-os">
          <?php
            $osName = $server->image_name ?? null;
            if(!$osName && isset($osList) && is_array($osList) && !empty($server->image)) {
              foreach($osList as $os) {
                if(($os['id'] ?? null) == $server->image) {
                  $osName = $os['name'] ?? $server->image;
                  break;
                }
              }
            }
            if(($server->provider ?? '') === 'hetzner' && !empty($apiData?->image?->description)) {
              $osName = $apiData->image->description;
            }
            if(!$osName) $osName = $server->image ?? '-';
          ?>
          <?php echo e($osName); ?>

        </span>
      </p>
    </div>
  </div>
</div><?php /**PATH /home/cloud/public_html/laravel-project/resources/views/servers/partials/overview-tab.blade.php ENDPATH**/ ?>