<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

/*
|--------------------------------------------------------------------------
| Maintenance Mode
|--------------------------------------------------------------------------
|
| اگر سایت در حالت تعمیر هست، این فایل اجرا می‌شود.
|
*/
if (file_exists($maintenance = __DIR__.'/laravel-project/storage/framework/maintenance.php')) {
    require $maintenance;
}

/*
|--------------------------------------------------------------------------
| Composer Autoload
|--------------------------------------------------------------------------
|
| بارگذاری تمام پکیج‌ها و کلاس‌ها
|
*/
require __DIR__.'/laravel-project/vendor/autoload.php';

/*
|--------------------------------------------------------------------------
| Bootstrap Laravel
|--------------------------------------------------------------------------
|
| راه‌اندازی برنامه لاراول
|
*/
$app = require_once __DIR__.'/laravel-project/bootstrap/app.php';

/*
|--------------------------------------------------------------------------
| Handle Request
|--------------------------------------------------------------------------
|
| درخواست HTTP گرفته شده، پردازش و پاسخ داده می‌شود
|
*/
$kernel = $app->make(Kernel::class);

$request = Request::capture();
$response = $kernel->handle($request);
$response->send();
$kernel->terminate($request, $response);
