<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('starter_kit.dashboards.ecommerce_dashboard');
});

Route::view('layout-light', 'starter_kit.color_version.layout_light')->name('layout_light');
Route::view('layout-dark', 'starter_kit.color_version.layout_dark')->name('layout_dark');

// starter kit->page layout
Route::view('box-layout', 'starter_kit.page_layout.box_layout')->name('box_layout');
Route::view('rtl-layout', 'starter_kit.page_layout.rtl_layout')->name('rtl_layout');

Route::view('ecommerce-dashboard', 'starter_kit.dashboards.ecommerce_dashboard')
    ->name('ecommerce_dashboard');

// hide menu on scroll
Route::view('hide-menu-on-scroll', 'starter_kit.hide_menu_on_scroll')->name('hide_menu_on_scroll');

// footers
Route::view('footer-light', 'starter_kit.footers.footer_light')->name('footer_light');
Route::view('footer-dark', 'starter_kit.footers.footer_dark')->name('footer_dark');
Route::view('footer-fixed', 'starter_kit.footers.footer_fixed')->name('footer_fixed');

use App\Http\Controllers\WhmcsAuthController;

Route::get('/login', function() {
    return view('auth.login'); // صفحه login Blade
})->name('login');

Route::post('/login', [WhmcsAuthController::class, 'login']);

Route::get('/logout', [WhmcsAuthController::class, 'logout'])->name('logout');

Route::middleware(['whmcs.auth'])->group(function() {
    Route::get('/dashboard', function() {
        $user = session('whmcs_user');
        return view('dashboard', compact('user'));
    })->name('dashboard');
});


